/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.FigText;

public class FigTextEditor
extends JTextPane
implements PropertyChangeListener,
DocumentListener,
KeyListener {
    public static int EXTRA = 2;
    FigText _target;
    JPanel drawingPanel;
    JPanel _glass;
    boolean _editing = false;

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateFigText();
    }

    public void endEditing() {
        if (!this._editing) {
            return;
        }
        this._editing = false;
        this._target.startTrans();
        this.updateFigText();
        this._target.endTrans();
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
        this._target.removePropertyChangeListener(this);
        this._target.firePropChange("editing", true, false);
        this.drawingPanel.requestFocus();
        this.removeKeyListener(this);
        this._glass.setVisible(false);
        Editor editor = Globals.curEditor();
        editor.setActiveTextEditor(null);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && !this._target.getMultiLine()) {
            keyEvent.consume();
        }
        if (keyEvent.getKeyCode() == 9 && !this._target.getAllowsTab()) {
            this.endEditing();
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && !this._target.getMultiLine()) {
            this.endEditing();
            keyEvent.consume();
        }
        if (keyEvent.getKeyCode() == 9) {
            if (!this._target.getAllowsTab()) {
                this.endEditing();
                keyEvent.consume();
            }
        } else if (keyEvent.getKeyCode() == 113) {
            this.endEditing();
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 27) {
            this.endEditing();
            keyEvent.consume();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateFigText();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateFigText();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateFigText();
    }

    protected void updateFigText() {
        if (this._target == null) {
            return;
        }
        String string = this.getText();
        this._target.setText(string);
        this._target.calcBounds();
        Rectangle rectangle = this._target.getBounds();
        rectangle = SwingUtilities.convertRectangle(this.drawingPanel, rectangle, this._glass);
        this.setBounds(rectangle.x - EXTRA, rectangle.y - EXTRA, rectangle.width + EXTRA * 2, rectangle.height + EXTRA * 2);
        this.setFont(this._target.getFont());
    }

    public FigTextEditor(FigText figText, InputEvent inputEvent) {
        this._target = figText;
        Editor editor = Globals.curEditor();
        if (!(editor.getAwtComponent() instanceof JComponent)) {
            System.out.println("not a JComponent");
            return;
        }
        this.drawingPanel = (JPanel)editor.getAwtComponent();
        this._target.firePropChange("editing", false, true);
        this._target.addPropertyChangeListener(this);
        Container container = this.drawingPanel;
        while (!(container instanceof JFrame) && container != null) {
            container = container.getParent();
        }
        if (!(container instanceof JFrame)) {
            System.out.println("no JFrame");
            return;
        }
        this._glass = (JPanel)((JFrame)container).getGlassPane();
        figText.calcBounds();
        Rectangle rectangle = figText.getBounds();
        rectangle = SwingUtilities.convertRectangle(this.drawingPanel, rectangle, this._glass);
        this.setBounds(rectangle.x - EXTRA, rectangle.y - EXTRA, rectangle.width + EXTRA * 2, rectangle.height + EXTRA * 2);
        this._glass.setVisible(true);
        this._glass.setLayout(null);
        this._glass.add(this);
        String string = figText.getText();
        if (!string.endsWith("\n")) {
            this.setText(string + "\n");
        }
        this.setText(string);
        this.addKeyListener(this);
        this.requestFocus();
        this.getDocument().addDocumentListener(this);
        editor.setActiveTextEditor(this);
        this._editing = true;
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getDocument().getLength());
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (figText.getJustification() == 2) {
            StyleConstants.setAlignment(simpleAttributeSet, 1);
        }
        if (figText.getJustification() == 1) {
            StyleConstants.setAlignment(simpleAttributeSet, 2);
        }
        Font font = figText.getFont();
        StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
        StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
        this.setParagraphAttributes(simpleAttributeSet, true);
        if (inputEvent instanceof KeyEvent) {
            this.setSelectionStart(this.getDocument().getLength());
            this.setSelectionEnd(this.getDocument().getLength());
        }
        this.setBorder(LineBorder.createGrayLineBorder());
    }
}

