var Exercice = function(template) {
	this.node = document.createElement("fieldset");
	this.explain = null;
	this.init(template);
};

Exercice.prototype.init = function(template) {
	this.node.className = "exercice";

	//question
	var question = document.getFirstChildByTagName(template, "question");
	if (question) {
		var div = document.createElement("div");
		div.className = "question";
		document.moveChilds(question, div);
		this.node.appendChild(div);
	}

	//titre
	var legend = document.createElement("legend");
	this.node.appendChild(legend);

	var title = document.getFirstChildByTagName(template, "title");
	if (title) {
		document.moveChilds(title, legend);
	}
	else {
		legend.appendChild(document.createTextNode("Exercice"));
	}
	
	document.mapWidgetTo(document.getChildsByTagName(template, "qcu"), QCU, this.node);
	document.mapWidgetTo(document.getChildsByTagName(template, "qcm"), QCM, this.node);
	document.mapWidgetTo(document.getChildsByTagName(template, "qnum"), QNum, this.node);
	document.mapWidgetTo(document.getChildsByTagName(template, "qplace"), QPlace, this.node);
	document.mapWidgetTo(document.getChildsByTagName(template, "explain"), ExerciceExplain, this.node);
};

var ExerciceExplain = function(template) {
	this.node = document.createElement("div");
	this.nodeContent = document.createElement("div");
	this.init(template);
};

ExerciceExplain.prototype.init = function(template) {
	var self = this;
	this.node.className = "explain";

	var a = document.createElement("a");
	a.onclick = function() { self.swVisibility() };
	a.appendChild(document.createTextNode(template.hasAttribute("title") ? template.getAttribute("title") : "explication"));
	this.setVisibility(false);
	this.node.appendChild(a);

	this.node.appendChild(this.nodeContent);
	this.nodeContent.className = "content";
	document.moveChilds(template, this.nodeContent);
};

ExerciceExplain.prototype.setVisibility = function(value) {
	this.nodeContent.style.display = value ? "" : "none";
};

ExerciceExplain.prototype.getVisibility = function() {
	return !this.nodeContent.style.display ? true : false;
};

ExerciceExplain.prototype.swVisibility = function() {
	this.setVisibility(!this.getVisibility());
};

var ExerciceResult = function() {
	this.node = document.createElement("div");
	this.triesCount = 0;
	this.previousValue = null;
	this.init();
};

ExerciceResult.prototype.init = function() {
	this.node.className = "result";
	this.node.appendChild(document.createTextNode(""));
};

ExerciceResult.prototype.set = function(value, message) {
	if (!this.previousValue || !value) this.triesCount++;
	this.previousValue = value;

	this.node.firstChild.nodeValue = message + " (tentatives : " + this.triesCount + ")";
	this.node.className = "result " + (
		value 
			? (this.triesCount < 3 ? "good" : "tomuchtries")
			: "wrong"
	);
};


