var Page = function(name) {
	this.name = name;
	this.menu = null;

	this.nodeHeader = document.createElement("header");
	this.nodeFooter = document.createElement("footer");
	this.nodeContent = document.createElement("div");
	this.widgetGlossary = !glossary.empty() ? new GlossaryWidget(glossary) : null;
};

Page.prototype.createPartners = function(list) {
	var div = document.createElement("div");
	div.className = "partners";

	for (var i = 0; i < list.length; i++) {
		var img = document.createElement("img");
		img.src = list[i];
		div.appendChild(img);
	}
	return div;		
};

Page.prototype.hasMathmlSupport = function() {
	return false;
};

Page.prototype.transformMathml = function(node) {
	for (var child = node.firstChild; child != null; child = child.nextSibling) {
		if (child.nodeType == Node.ELEMENT_NODE) {
			if (child.tagName.toLowerCase() == "math" && child.hasAttribute("alt")) {
				var img = document.createElement("img");
				img.className = "mathml";
				img.src = child.getAttribute("alt");
				child.parentNode.replaceChild(img, child);
				child = img;
			}
			this.transformMathml(child);
		}
	}
};

Page.prototype.hasThoptSupport = function() {
	return navigator.userAgent == "EspFx";
};

Page.prototype.enableThopt = function(node, value) {
	for (var child = node.firstChild; child != null; child = child.nextSibling) {
		if (child.nodeType == Node.ELEMENT_NODE) {
			if (child.tagName.toLowerCase() == "a" && child.className == "thermoptim") {
				child.className = "thermoptim " + (value ? "enabled" : "disabled");
			}
			this.enableThopt(child, value);
		}
	}
};

Page.prototype.show = function() {
	var self = this;
	if (!this.hasMathmlSupport())
		this.transformMathml(document.body);

	this.enableThopt(document.body, this.hasThoptSupport());

	//Content
	this.nodeContent.className = "content";
	while (document.body.firstChild) this.nodeContent.appendChild(document.body.firstChild);

	if (glossary) {
		glossary.addDefinitions(this.nodeContent, function(def) {
			self.widgetGlossary.show(def);
		});
	}
	document.mapWidget(this.nodeContent.getElementsByTagName("exercice"), Exercice);
	document.mapWidget(this.nodeContent.getElementsByTagName("sections"), Sections);

	//Menu
	if (typeof settings !== "undefined") {
		if ("menu" in settings) {
			this.menu = new Menu(settings.menu, this.name);
			this.nodeHeader.appendChild(this.menu.node);
		}

		//Footer
		if ("license" in settings) {
			this.nodeFooter.appendChild(document.createTextNode(settings.license));
		}

		if ("partners" in settings) {
			this.nodeFooter.appendChild(this.createPartners(settings.partners));
		}
		
		if (this.widgetGlossary) {
			var ul = document.createElement("ul");
			ul.className = "tools";
			
			var li = document.createElement("li");
			var img = document.createElement("img");
			img.src = "img/icons/lecon.png";
			li.appendChild(img);
			li.appendChild(document.createTextNode("Glossaire"));
			li.onclick = function() { self.widgetGlossary.show() };
			ul.appendChild(li);
			
			this.menu.addItem(ul);
		}
	}

	document.body.appendChild(this.nodeHeader);
	document.body.appendChild(this.nodeContent);
	if (this.nodeFooter.childNodes.length > 0) document.body.appendChild(this.nodeFooter);
	if (this.widgetGlossary) document.body.appendChild(this.widgetGlossary.node);
};

