var QCU = function(template) {
	this.node = document.createElement("form");
	this.node.className = "qcu";
	this.id = QCU.createId();
	this.items = null;
	this.result = new ExerciceResult();
	this.init(template);
};

QCU.count = 0;

QCU.createId = function() {
	return "qcu." + (++QCU.count);
};

QCU.prototype.init = function(template) {
	var self = this;
	this.node.onsubmit = function() { self.onsubmit(); return false; };

	//items
	this.items = (template.getAttribute("type") == "select")
		? new QCUItemsOption(template, this.id)
		: new QCUItemsRadio(template, this.id);

	this.node.appendChild(this.items.node);

	//bouton
	var button = document.createElement("button");
	button.appendChild(document.createTextNode("Ok"));
	this.node.appendChild(button);

	this.node.appendChild(this.result.node);
};

QCU.prototype.onsubmit = function() {
	var selected = this.items.getSelected();
	if (!selected) {
		this.result.set(false, "Veuillez choisir une réponse !");
	}
	else {
		this.result.set(selected.answer, selected.msg);
	}
};

//--- Items Radio ---
var QCUItemsRadio = function(template, id) {
	this.list = [];
	this.id = id;
	this.init(template);
};

QCUItemsRadio.prototype.init = function(template) {
	this.node = document.createElement("table");
	var choices = document.getChildsByTagName(template, "choice");
	for (var i = 0; i < choices.length; i++) {
		var item = new QCUItemRadio(choices[i], this.id, this.id + "." + i);
		this.list.push(item);
		this.node.appendChild(item.node);
	}
};

QCUItemsRadio.prototype.getSelected = function() {
	for (var i = 0; i < this.list.length; i++) {
		var item = this.list[i];
		if (item.value())
			return item;
	}
	return null;
};

//--- Item Radio ---
var QCUItemRadio = function(template, name, id) {
	this.answer = template.getAttribute("result") == "true" ? true : false;
	this.msg = template.getAttribute("message");
	this.node = document.createElement("tr");
	this.name = name;
	this.id = id;
	this.init(template);
};

QCUItemRadio.prototype.init = function(template) {
	var td = document.createElement("td");
	this.node.appendChild(td);

	this.nodeInput = document.createElement("input");
	this.nodeInput.type = "radio";
	this.nodeInput.value = template.getAttribute("value");
	this.nodeInput.name = this.name;
	this.nodeInput.id = this.id;
	td.appendChild(this.nodeInput);

	var td = document.createElement("td");
	this.node.appendChild(td);

	var label = document.createElement("label");
	label.setAttribute("for", this.id); 
	td.appendChild(label);
	document.moveChilds(template, label);
};

QCUItemRadio.prototype.value = function() {
	return this.nodeInput.checked;
};

//--- Items Option ---
var QCUItemsOption = function(template, id) {
	this.list = [];
	this.node = document.createElement("select");
	this.id = id;
	this.init(template);
};

QCUItemsOption.prototype.init = function(template) {
	this.node.appendChild(document.createElement("option"));

	var choices = document.getChildsByTagName(template, "choice");
	for (var i = 0; i < choices.length; i++) {
		var item = new QCUItemOption(choices[i]);
		this.list.push(item);
		this.node.appendChild(item.node);
	}
};

QCUItemsOption.prototype.getSelected = function() {
	var idx = this.node.selectedIndex;
	return idx > 0 ? this.list[idx - 1] : null;
};

//--- Item Option ---
var QCUItemOption = function(template) {
	this.answer = template.getAttribute("result") == "true" ? true : false;
	this.msg = template.getAttribute("message");
	this.node = document.createElement("option");
	document.moveChilds(template, this.node);
};

