<?php

function auditLine($line, $script = false) {
	foreach(array(":", ";", "?", "!", "%") as $char) {
		if (strpos($line, " ".$char) !== false) {
			return "espace classique avant caractère spécial «".$char."»";
		}
	}

	if (preg_match("/[0-9] °/", $line)) {
		return "espace classique avant caractère spécial «°»";
	}

	if (!$script) {
		foreach(array("=", "&gt;", "&lt;", "+") as $char) {
			if (strpos($line, " ".$char) !== false || strpos($line, $char." ") !== false) {
				return "espace classique avant ou après caractère spécial «".$char."»";
			}	
		}
	}
/*
	foreach(array(";", "%", ":", "%") as $char) {
		$pattern = "/[a-zA-Z]{2}".$char."/";
		if (preg_match($pattern, $line)) {
			return "espace insécable manquant avant caractère spécial «".$char."»";
		}
	}
*/	
	foreach(array(",", ";", "%", ":") as $char) {
		$pattern = "/".$char."[a-zA-Z]{2}/";
		if (preg_match($pattern, $line)) {
			return "espace manquant après caractère spécial «".$char."»";
		}
	}

	foreach(array("&quot;", "&nbsp;", "  ", "«", "»", " </", "...", "  ", "  ", " >", " />", "( ", " )", "oeud") as $str) {
		if (strpos($line, $str) !== false) {
			return "utilisation chaine interdite «".$str."»";
		}
	}

	foreach(array("strong", "u", "b", "br") as $tagname) {
		if (strpos($line, "<".$tagname.">") !== false || strpos($line, "</".$tagname.">") !== false) {
			return "utilisation tag interdit «".$tagname."»";
		}
	}

	foreach(array("inline") as $class) {
		$str = "class=\"$class\"";
		if (strpos($line, $str) !== false) {
			return "classe obselète: «".$class."»";
		}
	}
	
	//nœud, coefficient, stoechiométrique
	/*
	foreach(array("A ", "Etud", "de schémas”", "du simulateur”", "unit=\"\"") as $str) {
		if (strpos($line, $str) !== false) {
			return "WARNING";
		}
	}
	*/

	foreach(array("TODO:") as $str) {
		if (strpos($line, $str) !== false) {
			return "COMMENT";
		}
	}


	return false;
}

function auditFile($filename) {
//	echo "---".$filename."---\n";
	$script = false;
	$l = 0;
	$f = fopen($filename, "r");
	while (($line = fgets($f)) !== false) {
		$l++;
		if (trim($line) == "<script>") $script = true;
		if (trim($line) == "</script>") $script = false;

		$error = auditLine($line, $script);
		if ($error) {
			echo $filename.":".$l." [".$error."]\n".$line;
		}
	}
}

function auditFiles($list) {
	foreach($list as $filename) {
		auditFile($filename);
	}
}

unset($argv[0]);
auditFiles($argv);

