<?php

function normalizeLine($line, $script = false) {
	$count = 1;
	while ($count > 0) {
		$line = str_replace("  ", " ", $line, $count);
	}

	foreach(array(":", ";", "?", "!", "%", "°") as $char) {
		$line = str_replace(" ".$char, " ".$char, $line);	
	}

	if (!$script) {
		foreach(array("+", "=", "?", "&lt;", "&gt;") as $char) {
			$line = str_replace(" ".$char." ", " ".$char." ", $line);	
		}
	}

	$arr = array(
		" &quot;" => " “",
		"(&quot;" => "(“",
		"&quot; " => "” ",
		"&quot;." => "”.",
		"&quot;," => "”,",
		"&quot;)" => "”)",
		"&nbsp;" => " ",
		"« " => "“",
		" »" => "”",
		"'" => "’",
		"(’" => "('",
		"’)" => "')",
		"..." => "…",
		" </" => "</",
		" />" => "/>",
		" >" => ">",
		"A titre " => "À titre ",
		"Etude " => "Étude ",
		"Etudions " => "Étudions ",
		"noeuds " => "nœuds ",
		"noeud " => "nœud ",
	);
	foreach($arr as $from => $to) {
		$line = str_replace($from, $to, $line);	
	}

	return $line;
}

function normalizeFile($filename, $of) {
	$script = false;
	$f = fopen($filename, "r");
	while (($line = fgets($f)) !== false) {
		if (trim($line) == "<script>") $script = true;
		if (trim($line) == "</script>") $script = false;
		$line = normalizeLine($line, $script);
		fwrite($of, $line);
	}
}


if (!isset($argv[1])) die("cmd source [target]\n");

$of = isset($argv[2]) ? @fopen($argv[2], "w") : STDOUT;
if (!$of) die("could not open output file.\n");

normalizeFile($argv[1], $of);



