/*
 * Decompiled with CFR 0.152.
 */
package linear_algebra;

import corejava.Console;
import java.util.Random;
import linear_algebra.Cholesky;
import linear_algebra.NotFullRankException;
import linear_algebra.NotPosDefException;
import linear_algebra.Triangular;

public class CholTest {
    public static void main(String[] args) {
        int k;
        int j;
        Cholesky cholesky = new Cholesky();
        Triangular triangular = new Triangular();
        double[][] r = new double[100][100];
        double[][] a = new double[100][100];
        double[][] a2 = new double[100][100];
        double[][] aupper = new double[100][100];
        double[][] aupper2 = new double[100][100];
        double[][] afull = new double[100][100];
        double[] x = new double[100];
        double[] y = new double[100];
        double[] b = new double[100];
        long randstart = Console.readInt("\nWhat is the starting value (an integer)\nfor the random number generator? ");
        int n = Console.readInt("\nWhat is the n value? (100 or less) ");
        Random rand01 = new Random(randstart);
        double randlow = Console.readDouble("\nWhat is randlow? ");
        double randhigh = Console.readDouble("\nWhat is randhigh? ");
        double randdiff = randhigh - randlow;
        int i = 0;
        while (i < n) {
            j = 0;
            while (j <= i) {
                r[i][j] = randlow + rand01.nextDouble() * randdiff;
                ++j;
            }
            ++i;
        }
        System.out.print("\n\n");
        System.out.print("*********************************************\n");
        System.out.print("\nThe r matrix is \n\n");
        i = 0;
        while (i < n) {
            j = 0;
            while (j <= i) {
                System.out.print(String.valueOf(r[i][j]) + "  ");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
        j = 0;
        while (j < n) {
            i = j;
            while (i < n) {
                a[i][j] = 0.0;
                k = 0;
                while (k <= j) {
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + r[i][k] * r[j][k];
                    ++k;
                }
                a2[i][j] = a[i][j];
                afull[i][j] = a[i][j];
                afull[j][i] = afull[i][j];
                aupper[j][i] = a[i][j];
                aupper2[j][i] = a[i][j];
                ++i;
            }
            ++j;
        }
        i = 0;
        while (i < n) {
            x[i] = randlow + rand01.nextDouble() * randdiff;
            ++i;
        }
        i = 0;
        while (i < n) {
            b[i] = 0.0;
            j = 0;
            while (j < n) {
                int n3 = i;
                b[n3] = b[n3] + afull[i][j] * x[j];
                ++j;
            }
            ++i;
        }
        try {
            cholesky.factorPosDef(a, n);
        }
        catch (NotPosDefException notPosDefException) {
            System.out.print("\nThe matrix was not positive definite so it was not possible\nto obtain a Cholesky decomposition.\n\n");
            System.exit(0);
        }
        System.out.print("\n\nThe recovered r matrix is \n\n");
        i = 0;
        while (i < n) {
            j = 0;
            while (j <= i) {
                System.out.print(String.valueOf(a[i][j]) + "  ");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
        System.out.print("\n");
        System.out.print("*********************************************\n");
        System.out.print("\n");
        try {
            cholesky.solvePosDef(a, b, y, n, true);
        }
        catch (NotPosDefException notPosDefException) {
            System.out.print("\nThe matrix was not positive definite so it was not possible\nto solve Ax = b.\n\n");
        }
        System.out.print("\nThe input x vector was\n\n");
        i = 0;
        while (i < n) {
            System.out.print(String.valueOf(x[i]) + "\n");
            ++i;
        }
        System.out.print("\n\nThe recovered x vector was\n\n");
        i = 0;
        while (i < n) {
            System.out.print(String.valueOf(b[i]) + "\n");
            ++i;
        }
        System.out.print("\n");
        System.out.print("\n");
        System.out.print("*********************************************\n");
        System.out.print("\n");
        try {
            cholesky.invertPosDef(a2, n, false);
        }
        catch (NotPosDefException notPosDefException) {
            System.out.print("\nThe matrix was not positive definite so it was not possible\nto use a Cholesky decomposition to obtain an inverse.\n\n");
        }
        i = 0;
        while (i < n - 1) {
            j = i + 1;
            while (j < n) {
                a2[i][j] = a2[j][i];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            j = 0;
            while (j <= i) {
                a[i][j] = 0.0;
                k = 0;
                while (k < n) {
                    double[] dArray = a[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + a2[i][k] * afull[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        System.out.print("\nA test of Cholesky.invertPosDef\n\nThe lower triangle of the I matrix is:\n\n");
        i = 0;
        while (i < n) {
            j = 0;
            while (j <= i) {
                System.out.print(String.valueOf(a[i][j]) + "  ");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
        System.out.print("\n");
        System.out.print("\n");
        System.out.print("*********************************************\n");
        System.out.print("\n");
        try {
            triangular.invertUpper(aupper, n);
        }
        catch (NotFullRankException notFullRankException) {
            System.out.print("\nThe upper triangular matrix was not of full rank\n so it was not possible to invert it.\n\n");
        }
        i = 0;
        while (i < n) {
            j = i;
            while (j < n) {
                a[i][j] = 0.0;
                k = 0;
                while (k < n) {
                    double[] dArray = a[i];
                    int n5 = j;
                    dArray[n5] = dArray[n5] + aupper[i][k] * aupper2[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        System.out.print("\nA test of Triangular.invertUpper\n\nThe transpose of the upper triangle of the I matrix is:\n\n");
        i = 0;
        while (i < n) {
            j = 0;
            while (j <= i) {
                System.out.print(String.valueOf(a[j][i]) + "  ");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
        System.out.print("\n");
        System.out.print("\n");
        System.out.print("*********************************************\n");
        System.out.print("\n");
    }
}

