/*
 * Decompiled with CFR 0.152.
 */
package linear_algebra;

import linear_algebra.NotFullRankException;
import linear_algebra.NotPosDefException;
import linear_algebra.Triangular;

public class Cholesky {
    public void factorPosDef(double[][] a, int n) throws NotPosDefException {
        int i = 0;
        while (i < n) {
            double sum = 0.0;
            int j = 0;
            while (j < i) {
                sum += a[i][j] * a[i][j];
                ++j;
            }
            double diff = a[i][i] - sum;
            if (diff <= 0.0) {
                System.out.print("\nCholesky.factorPosDef error:  A is not positive definite.\nThe i value at which a non-positive a[i][i] - sum value\nwas encountered is " + i + ".\n\n");
                throw new NotPosDefException();
            }
            a[i][i] = Math.sqrt(diff);
            int l = i + 1;
            while (l < n) {
                sum = 0.0;
                j = 0;
                while (j < i) {
                    sum += a[l][j] * a[i][j];
                    ++j;
                }
                a[l][i] = (a[l][i] - sum) / a[i][i];
                ++l;
            }
            ++i;
        }
    }

    public void solvePosDef(double[][] a, double[] b, double[] y, int n, boolean factored) throws NotPosDefException {
        Cholesky cholesky = new Cholesky();
        Triangular triangular = new Triangular();
        if (!factored) {
            try {
                cholesky.factorPosDef(a, n);
            }
            catch (NotPosDefException npd) {
                System.out.print("\nCholesky.solvePosDef error:  The matrix was not positive definite\nso it was not possibleto use the Cholesky decomposition\n to solve Ax = b.\n\n");
                throw npd;
            }
        }
        try {
            triangular.solveLower(a, y, b, n);
        }
        catch (NotFullRankException notFullRankException) {
            System.out.print("\nTriangular.solveLower error:  The lower triangular factor of A\nwas not of full rank.\n\n");
            throw new NotPosDefException();
        }
        int i = 0;
        while (i < n) {
            int j = i;
            while (j < n) {
                a[i][j] = a[j][i];
                ++j;
            }
            ++i;
        }
        try {
            triangular.solveUpper(a, b, y, n);
        }
        catch (NotFullRankException notFullRankException) {
            System.out.print("\nTriangular.solveUpper error:  The upper triangular factor of A\nwas not of full rank.\n\n");
            throw new NotPosDefException();
        }
    }

    public void invertPosDef(double[][] a, int n, boolean factored) throws NotPosDefException {
        Cholesky cholesky = new Cholesky();
        Triangular triangular = new Triangular();
        if (!factored) {
            try {
                cholesky.factorPosDef(a, n);
            }
            catch (NotPosDefException npd) {
                System.out.print("\nCholesky.invertPosDef error:  The matrix was not positive definite\nso it was not possibleto use the Cholesky decomposition\n to obtain an inverse.\n\n");
                throw npd;
            }
        }
        try {
            triangular.invertLower(a, n);
        }
        catch (NotFullRankException notFullRankException) {
            System.out.print("\nCholesky.invertPosDef error:  The matrix was not positive definite\nso it was not possibleto use the Cholesky decomposition\n to obtain an inverse.\n\n");
            throw new NotPosDefException();
        }
        int j = 0;
        while (j < n) {
            int i = j;
            while (i < n) {
                double sum = 0.0;
                int k = i;
                while (k < n) {
                    sum += a[k][i] * a[k][j];
                    ++k;
                }
                a[i][j] = sum;
                ++i;
            }
            ++j;
        }
    }
}

