/*
 * Decompiled with CFR 0.152.
 */
package linear_algebra;

import linear_algebra.Blas_f77;
import linear_algebra.NotFullRankException;

public class LU_f77 {
    public static void dgefa_f77(double[][] a, int n, int[] ipvt) throws NotFullRankException {
        int nm1 = n - 1;
        int k = 1;
        while (k <= nm1) {
            int l;
            int kp1 = k + 1;
            ipvt[k] = l = Blas_f77.colisamax_f77(n - k + 1, a, 1, k, k) + k - 1;
            if (a[l][k] != 0.0) {
                double t;
                if (l != k) {
                    t = a[l][k];
                    a[l][k] = a[k][k];
                    a[k][k] = t;
                }
                t = -1.0 / a[k][k];
                Blas_f77.colscal_f77(n - k, t, a, k + 1, k);
                int j = kp1;
                while (j <= n) {
                    t = a[l][j];
                    if (l != k) {
                        a[l][j] = a[k][j];
                        a[k][j] = t;
                    }
                    Blas_f77.colaxpy_f77(n - k, t, a, k + 1, k, j);
                    ++j;
                }
            } else {
                throw new NotFullRankException(k);
            }
            ++k;
        }
        ipvt[n] = n;
        if (a[n][n] == 0.0) {
            throw new NotFullRankException(n);
        }
    }

    public static void dgesl_f77(double[][] a, int n, int[] ipvt, double[] b, int job) {
        int nm1 = n - 1;
        if (job == 0) {
            double t;
            int k = 1;
            while (k <= nm1) {
                int l = ipvt[k];
                t = b[l];
                if (l != k) {
                    b[l] = b[k];
                    b[k] = t;
                }
                Blas_f77.colvaxpy_f77(n - k, t, a, b, k + 1, k);
                ++k;
            }
            int kb = 1;
            while (kb <= n) {
                int n2 = k = n + 1 - kb;
                b[n2] = b[n2] / a[k][k];
                t = -b[k];
                Blas_f77.colvaxpy_f77(k - 1, t, a, b, 1, k);
                ++kb;
            }
        } else {
            double t;
            int k = 1;
            while (k <= n) {
                t = Blas_f77.colvdot_f77(k - 1, a, b, 1, k);
                b[k] = (b[k] - t) / a[k][k];
                ++k;
            }
            int kb = 1;
            while (kb <= nm1) {
                int n3 = k = n - kb;
                b[n3] = b[n3] + Blas_f77.colvdot_f77(n - k, a, b, k + 1, k);
                int l = ipvt[k];
                if (l != k) {
                    t = b[l];
                    b[l] = b[k];
                    b[k] = t;
                }
                ++kb;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void dgedi_f77(double[][] a, int n, int[] ipvt, double[] det, double[] work, int job) {
        block12: {
            if (job / 10 == 0) break block12;
            det[1] = 1.0;
            det[2] = 0.0;
            ten = 10.0;
            i = 1;
            while (i <= n) {
                if (ipvt[i] != i) {
                    det[1] = -det[1];
                }
                det[1] = det[1] * a[i][i];
                if (det[1] != 0.0) ** GOTO lbl14
                break;
lbl-1000:
                // 1 sources

                {
                    det[1] = det[1] * ten;
                    det[2] = det[2] - 1.0;
lbl14:
                    // 2 sources

                    ** while (Math.abs((double)det[1]) < 1.0)
                }
lbl15:
                // 2 sources

                while (Math.abs(det[1]) >= ten) {
                    det[1] = det[1] / ten;
                    det[2] = det[2] + 1.0;
                }
                ++i;
            }
        }
        if (job % 10 != 0) {
            k = 1;
            while (k <= n) {
                a[k][k] = 1.0 / a[k][k];
                t = -a[k][k];
                Blas_f77.colscal_f77(k - 1, t, a, 1, k);
                kp1 = k + 1;
                if (n >= kp1) {
                    j = kp1;
                    while (j <= n) {
                        t = a[k][j];
                        a[k][j] = 0.0;
                        Blas_f77.colaxpy_f77(k, t, a, 1, k, j);
                        ++j;
                    }
                }
                ++k;
            }
            nm1 = n - 1;
            kb = 1;
            while (kb <= nm1) {
                k = n - kb;
                i = kp1 = k + 1;
                while (i <= n) {
                    work[i] = a[i][k];
                    a[i][k] = 0.0;
                    ++i;
                }
                j = kp1;
                while (j <= n) {
                    t = work[j];
                    Blas_f77.colaxpy_f77(n, t, a, 1, j, k);
                    ++j;
                }
                l = ipvt[k];
                if (l != k) {
                    Blas_f77.colswap_f77(n, a, k, l);
                }
                ++kb;
            }
        }
    }
}

