/*
 * Decompiled with CFR 0.152.
 */
package linear_algebra;

import corejava.Console;
import java.util.Random;
import linear_algebra.QR_f77;

public class QRTest_f77 {
    public static void main(String[] args) {
        int j;
        int info = 0;
        double[][] x = new double[101][101];
        double[] y = new double[101];
        double[] b0 = new double[101];
        double[] b = new double[101];
        double[] qraux = new double[101];
        double[] work = new double[101];
        double[] qy = new double[101];
        double[] qty = new double[101];
        double[] rsd = new double[101];
        double[] xb = new double[101];
        int[] jpvt = new int[101];
        int n = Console.readInt("\nWhat is the n value? (100 or less) ");
        long randstart = Console.readInt("\nWhat is the starting value (an integer)\nfor the random number generator? ");
        Random rand01 = new Random(randstart);
        double randlow = Console.readDouble("\nWhat is randlow? ");
        double randhigh = Console.readDouble("\nWhat is randhigh? ");
        double randdiff = randhigh - randlow;
        double sd = Console.readDouble("\nWhat is the standard deviation? ");
        int i = 1;
        while (i <= n) {
            j = 1;
            while (j <= n) {
                x[i][j] = randlow + rand01.nextDouble() * randdiff;
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= n) {
            b0[i] = randlow + rand01.nextDouble() * randdiff;
            ++i;
        }
        i = 1;
        while (i <= n) {
            y[i] = 0.0;
            j = 1;
            while (j <= n) {
                int n2 = i;
                y[n2] = y[n2] + x[i][j] * b0[j];
                ++j;
            }
            ++i;
        }
        int job = 0;
        QR_f77.dqrdc_f77(x, n, n, qraux, jpvt, work, job);
        job = 100;
        info = QR_f77.dqrsl_f77(x, n, n, qraux, y, qy, qty, b, rsd, xb, job);
        System.out.print("\nThe info value returned by QR_f77.dqrsl_f77 was: " + info + "\n\n");
        System.out.print("\nThe input b vector was:\n\n");
        i = 1;
        while (i <= n) {
            System.out.print(String.valueOf(b0[i]) + "\n");
            ++i;
        }
        System.out.print("\n\nThe recovered b vector was:\n\n");
        i = 1;
        while (i <= n) {
            System.out.print(String.valueOf(b[i]) + "\n");
            ++i;
        }
        System.out.print("\n");
        System.out.print("\n");
        System.out.print("*********************************************\n");
        System.out.print("\n");
        i = 1;
        while (i <= n) {
            x[i][1] = 1.0;
            x[i][2] = -1.0 + rand01.nextDouble() * 2.0;
            x[i][3] = x[i][2] * x[i][2];
            y[i] = x[i][1] + x[i][2] + x[i][3] + sd * QRTest_f77.normi(rand01.nextDouble());
            ++i;
        }
        job = 0;
        QR_f77.dqrdc_f77(x, n, 3, qraux, jpvt, work, job);
        job = 111;
        info = QR_f77.dqrsl_f77(x, n, 3, qraux, y, qy, qty, b, rsd, xb, job);
        System.out.print("\nThe info value returned by QR_f77.dqrsl_f77 was: " + info + "\n\n");
        System.out.print("\nThe input b vector was: \n\n1\n1\n1\n\n");
        System.out.print("\n\nThe recovered b vector was:\n\n");
        i = 1;
        while (i <= 3) {
            System.out.print(String.valueOf(b[i]) + "\n");
            ++i;
        }
        double rss = 0.0;
        i = 1;
        while (i <= n) {
            rss += rsd[i] * rsd[i];
            ++i;
        }
        sd = Math.sqrt(rss / ((double)n - 1.0));
        System.out.print("\nThe estimate of sigma from the rsd vector");
        System.out.print(" was " + sd + "\n");
        rss = 0.0;
        i = 1;
        while (i <= n) {
            double diff = y[i] - xb[i];
            rss += diff * diff;
            ++i;
        }
        sd = Math.sqrt(rss / ((double)n - 1.0));
        System.out.print("\nThe estimate of sigma from the xb vector");
        System.out.print(" was " + sd + "\n");
        System.out.print("\n");
        System.out.print("\n");
        System.out.print("*********************************************\n");
        System.out.print("\n");
    }

    public static double normi(double u) {
        double[] c = new double[4];
        double[] d = new double[4];
        c[1] = 2.515517;
        c[2] = 0.802853;
        c[3] = 0.010328;
        d[1] = 1.4327880000000002;
        d[2] = 0.189269;
        d[3] = 0.001308;
        if (u <= 0.5) {
            double arg = -2.0 * Math.log(u);
            double t = Math.sqrt(arg);
            double t2 = t * t;
            double t3 = t2 * t;
            double xnum = c[1] + c[2] * t + c[3] * t2;
            double xden = 1.0 + d[1] * t + d[2] * t2 + d[3] * t3;
            double normi = -(t - xnum / xden);
            return normi;
        }
        double arg = -2.0 * Math.log(1.0 - u);
        double t = Math.sqrt(arg);
        double t2 = t * t;
        double t3 = t2 * t;
        double xnum = c[1] + c[2] * t + c[3] * t2;
        double xden = 1.0 + d[1] * t + d[2] * t2 + d[3] * t3;
        double normi = t - xnum / xden;
        return normi;
    }
}

