/*
 * Decompiled with CFR 0.152.
 */
package linear_algebra;

import linear_algebra.Blas_f77;

public class QR_f77 {
    public static void dqrdc_f77(double[][] x, int n, int p, double[] qraux, int[] jpvt, double[] work, int job) {
        int jp;
        int j;
        int pl = 1;
        int pu = 0;
        if (job != 0) {
            j = 1;
            while (j <= p) {
                boolean swapj = jpvt[j] > 0;
                boolean negj = jpvt[j] < 0;
                jpvt[j] = j;
                if (negj) {
                    jpvt[j] = -j;
                }
                if (swapj) {
                    if (j != pl) {
                        Blas_f77.colswap_f77(n, x, pl, j);
                    }
                    jpvt[j] = jpvt[pl];
                    jpvt[pl] = j;
                    ++pl;
                }
                ++j;
            }
            pu = p;
            int jj = 1;
            while (jj <= p) {
                j = p - jj + 1;
                if (jpvt[j] < 0) {
                    jpvt[j] = -jpvt[j];
                    if (j != pu) {
                        Blas_f77.colswap_f77(n, x, pu, j);
                        jp = jpvt[pu];
                        jpvt[pu] = jpvt[j];
                        jpvt[j] = jp;
                    }
                    --pu;
                }
                ++jj;
            }
        }
        j = pl;
        while (j <= pu) {
            qraux[j] = Blas_f77.colnrm2_f77(n, x, 1, j);
            work[j] = qraux[j];
            ++j;
        }
        int lup = Math.min(n, p);
        int l = 1;
        while (l <= lup) {
            double nrmxl;
            if (l >= pl && l < pu) {
                double maxnrm = 0.0;
                int maxj = l;
                j = l;
                while (j <= pu) {
                    if (qraux[j] > maxnrm) {
                        maxnrm = qraux[j];
                        maxj = j;
                    }
                    ++j;
                }
                if (maxj != l) {
                    Blas_f77.colswap_f77(n, x, l, maxj);
                    qraux[maxj] = qraux[l];
                    work[maxj] = work[l];
                    jp = jpvt[maxj];
                    jpvt[maxj] = jpvt[l];
                    jpvt[l] = jp;
                }
            }
            qraux[l] = 0.0;
            if (l != n && (nrmxl = Blas_f77.colnrm2_f77(n - l + 1, x, l, l)) != 0.0) {
                int lp1;
                if (x[l][l] != 0.0) {
                    nrmxl = Blas_f77.sign_f77(nrmxl, x[l][l]);
                }
                Blas_f77.colscal_f77(n - l + 1, 1.0 / nrmxl, x, l, l);
                double[] dArray = x[l];
                int n2 = l;
                dArray[n2] = dArray[n2] + 1.0;
                j = lp1 = l + 1;
                while (j <= p) {
                    double t = -Blas_f77.coldot_f77(n - l + 1, x, l, l, j) / x[l][l];
                    Blas_f77.colaxpy_f77(n - l + 1, t, x, l, l, j);
                    if (j >= pl && j <= pu && qraux[j] != 0.0) {
                        double fac = Math.abs(x[l][j]) / qraux[j];
                        double tt = 1.0 - fac * fac;
                        t = tt = Math.max(tt, 0.0);
                        fac = qraux[j] / work[j];
                        if ((tt = 1.0 + 0.05 * tt * fac * fac) != 1.0) {
                            int n3 = j;
                            qraux[n3] = qraux[n3] * Math.sqrt(t);
                        } else {
                            qraux[j] = Blas_f77.colnrm2_f77(n - l, x, l + 1, j);
                            work[j] = qraux[j];
                        }
                    }
                    ++j;
                }
                qraux[l] = x[l][l];
                x[l][l] = -nrmxl;
            }
            ++l;
        }
    }

    public static int dqrsl_f77(double[][] x, int n, int k, double[] qraux, double[] y, double[] qy, double[] qty, double[] b, double[] rsd, double[] xb, int job) {
        int i;
        double t;
        double temp;
        int j;
        int jj;
        int info = 0;
        boolean cqy = job / 10000 != 0;
        boolean cqty = job % 10000 != 0;
        boolean cb = job % 1000 / 100 != 0;
        boolean cr = job % 100 / 10 != 0;
        boolean cxb = job % 10 != 0;
        int ju = Math.min(k, n - 1);
        if (ju == 0) {
            if (cqy) {
                qy[1] = y[1];
            }
            if (cqty) {
                qty[1] = y[1];
            }
            if (cxb) {
                xb[1] = y[1];
            }
            if (cb) {
                if (x[1][1] == 0.0) {
                    info = 1;
                } else {
                    b[1] = y[1] / x[1][1];
                }
            }
            if (cr) {
                rsd[1] = 0.0;
            }
            return info;
        }
        if (cqy) {
            Blas_f77.dcopy_f77(n, y, 1, qy, 1);
        }
        if (cqty) {
            Blas_f77.dcopy_f77(n, y, 1, qty, 1);
        }
        if (cqy) {
            jj = 1;
            while (jj <= ju) {
                j = ju - jj + 1;
                if (qraux[j] != 0.0) {
                    temp = x[j][j];
                    x[j][j] = qraux[j];
                    t = -Blas_f77.colvdot_f77(n - j + 1, x, qy, j, j) / x[j][j];
                    Blas_f77.colvaxpy_f77(n - j + 1, t, x, qy, j, j);
                    x[j][j] = temp;
                }
                ++jj;
            }
        }
        if (cqty) {
            j = 1;
            while (j <= ju) {
                if (qraux[j] != 0.0) {
                    temp = x[j][j];
                    x[j][j] = qraux[j];
                    t = -Blas_f77.colvdot_f77(n - j + 1, x, qty, j, j) / x[j][j];
                    Blas_f77.colvaxpy_f77(n - j + 1, t, x, qty, j, j);
                    x[j][j] = temp;
                }
                ++j;
            }
        }
        if (cb) {
            Blas_f77.dcopy_f77(k, qty, 1, b, 1);
        }
        int kp1 = k + 1;
        if (cxb) {
            Blas_f77.dcopy_f77(k, qty, 1, xb, 1);
        }
        if (cr && k < n) {
            Blas_f77.dcopyp_f77(n - k, qty, rsd, kp1);
        }
        if (cxb && kp1 <= n) {
            i = kp1;
            while (i <= n) {
                xb[i] = 0.0;
                ++i;
            }
        }
        if (cr) {
            i = 1;
            while (i <= k) {
                rsd[i] = 0.0;
                ++i;
            }
        }
        if (cb) {
            jj = 1;
            while (jj <= k) {
                j = k - jj + 1;
                if (x[j][j] == 0.0) {
                    info = j;
                    break;
                }
                b[j] = b[j] / x[j][j];
                if (j != 1) {
                    t = -b[j];
                    Blas_f77.colvaxpy_f77(j - 1, t, x, b, 1, j);
                }
                ++jj;
            }
        }
        if (cr || cxb) {
            jj = 1;
            while (jj <= ju) {
                j = ju - jj + 1;
                if (qraux[j] != 0.0) {
                    temp = x[j][j];
                    x[j][j] = qraux[j];
                    if (cr) {
                        t = -Blas_f77.colvdot_f77(n - j + 1, x, rsd, j, j) / x[j][j];
                        Blas_f77.colvaxpy_f77(n - j + 1, t, x, rsd, j, j);
                    }
                    if (cxb) {
                        t = -Blas_f77.colvdot_f77(n - j + 1, x, xb, j, j) / x[j][j];
                        Blas_f77.colvaxpy_f77(n - j + 1, t, x, xb, j, j);
                    }
                    x[j][j] = temp;
                }
                ++jj;
            }
        }
        return info;
    }
}

