/*
 * Decompiled with CFR 0.152.
 */
package linear_algebra;

import corejava.Console;
import java.util.Random;
import linear_algebra.Blas_f77;
import linear_algebra.SVDCException;
import linear_algebra.SVDC_f77;

public class SVDCTest_f77 {
    public static void main(String[] args) {
        int j;
        double[][] x = new double[101][101];
        double[][] copyx = new double[101][101];
        double[] y = new double[101];
        double[] b0 = new double[101];
        double[] b = new double[101];
        double[] s = new double[101];
        double[] e = new double[101];
        double[][] u = new double[101][101];
        double[][] ut = new double[101][101];
        double[][] v = new double[101][101];
        double[] work = new double[101];
        double[] pred = new double[101];
        double[] uty = new double[101];
        double[][] diag = new double[5][5];
        double[][] dut = new double[5][5];
        int n = Console.readInt("\nWhat is the n value? (100 or less) ");
        long randstart = Console.readInt("\nWhat is the starting value (an integer)\nfor the random number generator? ");
        Random rand01 = new Random(randstart);
        double randlow = Console.readDouble("\nWhat is randlow? ");
        double randhigh = Console.readDouble("\nWhat is randhigh? ");
        double randdiff = randhigh - randlow;
        double sd = Console.readDouble("\nWhat is the standard deviation? ");
        int i = 1;
        while (i <= n) {
            j = 1;
            while (j <= n) {
                x[i][j] = randlow + rand01.nextDouble() * randdiff;
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= n) {
            b0[i] = randlow + rand01.nextDouble() * randdiff;
            ++i;
        }
        i = 1;
        while (i <= n) {
            y[i] = 0.0;
            j = 1;
            while (j <= n) {
                int n2 = i;
                y[n2] = y[n2] + x[i][j] * b0[j];
                ++j;
            }
            ++i;
        }
        int job = 11;
        try {
            SVDC_f77.dsvdc_f77(x, n, n, s, e, u, v, work, job);
            Blas_f77.mattran_f77(u, ut, n, n);
            Blas_f77.matvec_f77(ut, y, uty, n, n);
            i = 1;
            while (i <= n) {
                uty[i] = uty[i] / s[i];
                ++i;
            }
            Blas_f77.matvec_f77(v, uty, b, n, n);
            System.out.print("\nThe input b vector was:\n\n");
            i = 1;
            while (i <= n) {
                System.out.print(String.valueOf(b0[i]) + "\n");
                ++i;
            }
            System.out.print("\n\nThe recovered b vector was:\n\n");
            i = 1;
            while (i <= n) {
                System.out.print(String.valueOf(b[i]) + "\n");
                ++i;
            }
        }
        catch (SVDCException svdce) {
            System.out.print("\nThere was an SVDC_f77 exception on the first test.\n\nThe info value from SVDC_f77 was " + svdce.info + ".\n\n");
        }
        System.out.print("\n");
        System.out.print("\n");
        System.out.print("*********************************************\n");
        System.out.print("\n");
        i = 1;
        while (i <= n) {
            x[i][1] = 1.0;
            copyx[i][1] = x[i][1];
            x[i][2] = -1.0 + rand01.nextDouble() * 2.0;
            copyx[i][2] = x[i][2];
            x[i][3] = x[i][2] * x[i][2];
            copyx[i][3] = x[i][3];
            y[i] = x[i][1] + x[i][2] + x[i][3] + sd * SVDCTest_f77.normi(rand01.nextDouble());
            ++i;
        }
        job = 21;
        try {
            SVDC_f77.dsvdc_f77(x, n, 3, s, e, u, v, work, job);
            Blas_f77.mattran_f77(u, ut, n, 3);
            Blas_f77.matvec_f77(ut, y, uty, 3, n);
            i = 1;
            while (i <= 3) {
                uty[i] = uty[i] / s[i];
                ++i;
            }
            b[1] = 0.0;
            b[2] = 0.0;
            b[3] = 0.0;
            Blas_f77.matvec_f77(v, uty, b, 3, 3);
            System.out.print("\nThe input b vector was: \n\n1\n1\n1\n\n");
            System.out.print("\n\nThe recovered b vector was:\n\n");
            i = 1;
            while (i <= 3) {
                System.out.print(String.valueOf(b[i]) + "\n");
                ++i;
            }
            Blas_f77.matvec_f77(copyx, b, pred, n, 3);
            double rss = 0.0;
            i = 1;
            while (i <= n) {
                double diff = y[i] - pred[i];
                rss += diff * diff;
                ++i;
            }
            sd = Math.sqrt(rss / ((double)n - 1.0));
            System.out.print("\nThe estimate of sigma from the residuals");
            System.out.print(" was " + sd + "\n");
        }
        catch (SVDCException svdce) {
            System.out.print("\nThere was an SVDC_f77 exception on the second test.\n\nThe info value from SVDC_f77 was " + svdce.info + ".\n\n");
        }
        System.out.print("\n");
        System.out.print("\n");
        System.out.print("*********************************************\n");
        System.out.print("\n\nEigenvalue, eigenvector test\n\n");
        i = 1;
        while (i <= 4) {
            y[i] = 1.0;
            ++i;
        }
        double onedsqrt4 = 1.0 / Blas_f77.dnrm2_f77(4, y, 1);
        i = 1;
        while (i <= 4) {
            u[i][1] = onedsqrt4;
            ++i;
        }
        u[1][2] = onedsqrt4;
        u[2][2] = -onedsqrt4;
        u[3][2] = onedsqrt4;
        u[4][2] = -onedsqrt4;
        u[1][3] = onedsqrt4;
        u[2][3] = -onedsqrt4;
        u[3][3] = -onedsqrt4;
        u[4][3] = onedsqrt4;
        u[1][4] = onedsqrt4;
        u[2][4] = onedsqrt4;
        u[3][4] = -onedsqrt4;
        u[4][4] = -onedsqrt4;
        Blas_f77.mattran_f77(u, ut, 4, 4);
        i = 1;
        while (i <= 4) {
            j = 1;
            while (j <= 4) {
                diag[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        diag[1][1] = 4.0;
        diag[2][2] = 3.0;
        diag[3][3] = 2.0;
        diag[4][4] = 1.0;
        Blas_f77.matmat_f77(diag, ut, dut, 4, 4, 4);
        Blas_f77.matmat_f77(u, dut, x, 4, 4, 4);
        job = 10;
        try {
            SVDC_f77.dsvdc_f77(x, 4, 4, s, e, u, v, work, job);
            System.out.print("\nThe eigenvalues should be 4,3,2,1.\n");
            System.out.print("\nThe calculated eigenvalues are:\n\n");
            System.out.print(String.valueOf(s[1]) + "\n");
            System.out.print(String.valueOf(s[2]) + "\n");
            System.out.print(String.valueOf(s[3]) + "\n");
            System.out.print(String.valueOf(s[4]) + "\n");
            System.out.print("\n\nThe eigenvectors should be (up to sign):\n\n");
            System.out.print(".5  .5  .5  .5\n");
            System.out.print(".5 -.5 -.5  .5\n");
            System.out.print(".5  .5 -.5 -.5\n");
            System.out.print(".5 -.5  .5 -.5\n");
            System.out.print("\n\nThe calculated eigenvectors are:\n\n");
            System.out.print(String.valueOf(u[1][1]) + "  " + u[1][2] + "  " + u[1][3] + "  " + u[1][4] + "\n");
            System.out.print(String.valueOf(u[2][1]) + "  " + u[2][2] + "  " + u[2][3] + "  " + u[2][4] + "\n");
            System.out.print(String.valueOf(u[3][1]) + "  " + u[3][2] + "  " + u[3][3] + "  " + u[3][4] + "\n");
            System.out.print(String.valueOf(u[4][1]) + "  " + u[4][2] + "  " + u[4][3] + "  " + u[4][4] + "\n");
        }
        catch (SVDCException svdce) {
            System.out.print("\nThere was an SVDC_f77 exception on the eigenvalue, eigenvector test.\n\nThe info value from SVDC_f77 was " + svdce.info + ".\n\n");
        }
    }

    public static double normi(double u) {
        double[] c = new double[4];
        double[] d = new double[4];
        c[1] = 2.515517;
        c[2] = 0.802853;
        c[3] = 0.010328;
        d[1] = 1.4327880000000002;
        d[2] = 0.189269;
        d[3] = 0.001308;
        if (u <= 0.5) {
            double arg = -2.0 * Math.log(u);
            double t = Math.sqrt(arg);
            double t2 = t * t;
            double t3 = t2 * t;
            double xnum = c[1] + c[2] * t + c[3] * t2;
            double xden = 1.0 + d[1] * t + d[2] * t2 + d[3] * t3;
            double normi = -(t - xnum / xden);
            return normi;
        }
        double arg = -2.0 * Math.log(1.0 - u);
        double t = Math.sqrt(arg);
        double t2 = t * t;
        double t3 = t2 * t;
        double xnum = c[1] + c[2] * t + c[3] * t2;
        double xden = 1.0 + d[1] * t + d[2] * t2 + d[3] * t3;
        double normi = t - xnum / xden;
        return normi;
    }
}

