/*
 * Decompiled with CFR 0.152.
 */
package linear_algebra;

import linear_algebra.Blas_f77;
import linear_algebra.SVDCException;

public class SVDC_f77 {
    public static void dsvdc_f77(double[][] x, int n, int p, double[] s, double[] e, double[][] u, double[][] v, double[] work, int job) throws SVDCException {
        int ll;
        int i;
        double t;
        int j;
        int lp1;
        double[] rotvec = new double[5];
        int ls = 0;
        int maxit = 30;
        boolean wantu = false;
        boolean wantv = false;
        int jobu = job % 100 / 10;
        int ncu = n;
        if (jobu > 1) {
            ncu = Math.min(n, p);
        }
        if (jobu != 0) {
            wantu = true;
        }
        if (job % 10 != 0) {
            wantv = true;
        }
        int nct = Math.min(n - 1, p);
        int nrt = Math.max(0, Math.min(p - 2, n));
        int lu = Math.max(nct, nrt);
        int l = 1;
        while (l <= lu) {
            lp1 = l + 1;
            if (l <= nct) {
                s[l] = Blas_f77.colnrm2_f77(n - l + 1, x, l, l);
                if (s[l] != 0.0) {
                    if (x[l][l] != 0.0) {
                        s[l] = Blas_f77.sign_f77(s[l], x[l][l]);
                    }
                    Blas_f77.colscal_f77(n - l + 1, 1.0 / s[l], x, l, l);
                    double[] dArray = x[l];
                    int n2 = l;
                    dArray[n2] = dArray[n2] + 1.0;
                }
                s[l] = -s[l];
            }
            j = lp1;
            while (j <= p) {
                if (l <= nct && s[l] != 0.0) {
                    t = -Blas_f77.coldot_f77(n - l + 1, x, l, l, j) / x[l][l];
                    Blas_f77.colaxpy_f77(n - l + 1, t, x, l, l, j);
                }
                e[j] = x[l][j];
                ++j;
            }
            if (wantu && l <= nct) {
                i = l;
                while (i <= n) {
                    u[i][l] = x[i][l];
                    ++i;
                }
            }
            if (l <= nrt) {
                e[l] = Blas_f77.dnrm2p_f77(p - l, e, lp1);
                if (e[l] != 0.0) {
                    if (e[lp1] != 0.0) {
                        e[l] = Blas_f77.sign_f77(e[l], e[lp1]);
                    }
                    Blas_f77.dscalp_f77(p - l, 1.0 / e[l], e, lp1);
                    int n3 = lp1;
                    e[n3] = e[n3] + 1.0;
                }
                e[l] = -e[l];
                if (lp1 <= n && e[l] != 0.0) {
                    i = lp1;
                    while (i <= n) {
                        work[i] = 0.0;
                        ++i;
                    }
                    j = lp1;
                    while (j <= p) {
                        Blas_f77.colvaxpy_f77(n - l, e[j], x, work, lp1, j);
                        ++j;
                    }
                    j = lp1;
                    while (j <= p) {
                        Blas_f77.colvraxpy_f77(n - l, -e[j] / e[lp1], work, x, lp1, j);
                        ++j;
                    }
                }
                if (wantv) {
                    i = lp1;
                    while (i <= p) {
                        v[i][l] = e[i];
                        ++i;
                    }
                }
            }
            ++l;
        }
        int m = Math.min(p, n + 1);
        if (nct < p) {
            s[nct + 1] = x[nct + 1][nct + 1];
        }
        if (n < m) {
            s[m] = 0.0;
        }
        if (nrt + 1 < m) {
            e[nrt + 1] = x[nrt + 1][m];
        }
        e[m] = 0.0;
        if (wantu) {
            j = nct + 1;
            while (j <= ncu) {
                i = 1;
                while (i <= n) {
                    u[i][j] = 0.0;
                    ++i;
                }
                u[j][j] = 1.0;
                ++j;
            }
            ll = 1;
            while (ll <= nct) {
                l = nct - ll + 1;
                if (s[l] != 0.0) {
                    j = lp1 = l + 1;
                    while (j <= ncu) {
                        t = -Blas_f77.coldot_f77(n - l + 1, u, l, l, j) / u[l][l];
                        Blas_f77.colaxpy_f77(n - l + 1, t, u, l, l, j);
                        ++j;
                    }
                    Blas_f77.colscal_f77(n - l + 1, -1.0, u, l, l);
                    double[] dArray = u[l];
                    int n4 = l;
                    dArray[n4] = dArray[n4] + 1.0;
                    int lm1 = l - 1;
                    i = 1;
                    while (i <= lm1) {
                        u[i][l] = 0.0;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= n) {
                        u[i][l] = 0.0;
                        ++i;
                    }
                    u[l][l] = 1.0;
                }
                ++ll;
            }
        }
        if (wantv) {
            ll = 1;
            while (ll <= p) {
                l = p - ll + 1;
                lp1 = l + 1;
                if (l <= nrt && e[l] != 0.0) {
                    j = lp1;
                    while (j <= p) {
                        t = -Blas_f77.coldot_f77(p - l, v, lp1, l, j) / v[lp1][l];
                        Blas_f77.colaxpy_f77(p - l, t, v, lp1, l, j);
                        ++j;
                    }
                }
                i = 1;
                while (i <= p) {
                    v[i][l] = 0.0;
                    ++i;
                }
                v[l][l] = 1.0;
                ++ll;
            }
        }
        int mm = m;
        int iter = 0;
        block22: while (m != 0) {
            int kase;
            double ztest;
            double test;
            if (iter >= maxit) {
                throw new SVDCException(m);
            }
            ll = 1;
            while (ll <= m) {
                l = m - ll;
                if (l == 0) break;
                test = Math.abs(s[l]) + Math.abs(s[l + 1]);
                ztest = test + Math.abs(e[l]);
                if (ztest == test) {
                    e[l] = 0.0;
                    break;
                }
                ++ll;
            }
            if (l == m - 1) {
                kase = 4;
            } else {
                lp1 = l + 1;
                int mp1 = m + 1;
                int lls = lp1;
                while (lls <= mp1) {
                    ls = m - lls + lp1;
                    if (ls == l) break;
                    test = 0.0;
                    if (ls != m) {
                        test += Math.abs(e[ls]);
                    }
                    if (ls != l + 1) {
                        test += Math.abs(e[ls - 1]);
                    }
                    if ((ztest = test + Math.abs(s[ls])) == test) {
                        s[ls] = 0.0;
                        break;
                    }
                    ++lls;
                }
                if (ls == l) {
                    kase = 3;
                } else if (ls == m) {
                    kase = 1;
                } else {
                    kase = 2;
                    l = ls;
                }
            }
            ++l;
            switch (kase) {
                default: {
                    continue block22;
                }
                case 1: {
                    double sn;
                    double cs;
                    double t1;
                    int k;
                    double f = e[m - 1];
                    e[m - 1] = 0.0;
                    int kk = l;
                    while (true) {
                        if (kk > m - 1) continue block22;
                        k = m - 1 - kk + l;
                        rotvec[1] = t1 = s[k];
                        rotvec[2] = f;
                        Blas_f77.drotg_f77(rotvec);
                        t1 = rotvec[1];
                        f = rotvec[2];
                        cs = rotvec[3];
                        sn = rotvec[4];
                        s[k] = t1;
                        if (k != l) {
                            f = -sn * e[k - 1];
                            int n5 = k - 1;
                            e[n5] = e[n5] * cs;
                        }
                        if (wantv) {
                            Blas_f77.colrot_f77(p, v, k, m, cs, sn);
                        }
                        ++kk;
                    }
                }
                case 2: {
                    double sn;
                    double cs;
                    double t1;
                    double f = e[l - 1];
                    e[l - 1] = 0.0;
                    int k = l;
                    while (true) {
                        if (k > m) continue block22;
                        rotvec[1] = t1 = s[k];
                        rotvec[2] = f;
                        Blas_f77.drotg_f77(rotvec);
                        t1 = rotvec[1];
                        f = rotvec[2];
                        cs = rotvec[3];
                        sn = rotvec[4];
                        s[k] = t1;
                        f = -sn * e[k];
                        int n6 = k;
                        e[n6] = e[n6] * cs;
                        if (wantu) {
                            Blas_f77.colrot_f77(n, u, k, l - 1, cs, sn);
                        }
                        ++k;
                    }
                }
                case 3: {
                    double sn;
                    double cs;
                    double scale = Math.max(Math.abs(s[m]), Math.abs(s[m - 1]));
                    scale = Math.max(Math.abs(e[m - 1]), scale);
                    scale = Math.max(Math.abs(s[l]), scale);
                    scale = Math.max(Math.abs(e[l]), scale);
                    double b = ((s[m - 1] + s[m]) * (s[m - 1] - s[m]) + e[m - 1] * e[m - 1]) / (2.0 * scale * scale);
                    double c = s[m] * e[m - 1] * (s[m] * e[m - 1]) / (scale * scale * scale * scale);
                    double shift = 0.0;
                    if (b != 0.0 || c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (s[l] + s[m]) * (s[l] - s[m]) / (scale * scale) - shift;
                    double g = s[l] * e[l] / (scale * scale);
                    int k = l;
                    while (k <= m - 1) {
                        rotvec[1] = f;
                        rotvec[2] = g;
                        Blas_f77.drotg_f77(rotvec);
                        f = rotvec[1];
                        g = rotvec[2];
                        cs = rotvec[3];
                        sn = rotvec[4];
                        if (k != l) {
                            e[k - 1] = f;
                        }
                        f = cs * s[k] + sn * e[k];
                        e[k] = cs * e[k] - sn * s[k];
                        g = sn * s[k + 1];
                        int n7 = k + 1;
                        s[n7] = s[n7] * cs;
                        if (wantv) {
                            Blas_f77.colrot_f77(p, v, k, k + 1, cs, sn);
                        }
                        rotvec[1] = f;
                        rotvec[2] = g;
                        Blas_f77.drotg_f77(rotvec);
                        f = rotvec[1];
                        g = rotvec[2];
                        cs = rotvec[3];
                        sn = rotvec[4];
                        s[k] = f;
                        f = cs * e[k] + sn * s[k + 1];
                        s[k + 1] = -sn * e[k] + cs * s[k + 1];
                        g = sn * e[k + 1];
                        int n8 = k + 1;
                        e[n8] = e[n8] * cs;
                        if (wantu && k < n) {
                            Blas_f77.colrot_f77(n, u, k, k + 1, cs, sn);
                        }
                        ++k;
                    }
                    e[m - 1] = f;
                    ++iter;
                    continue block22;
                }
                case 4: 
            }
            if (s[l] < 0.0) {
                s[l] = -s[l];
                if (wantv) {
                    Blas_f77.colscal_f77(p, -1.0, v, 1, l);
                }
            }
            while (l != mm) {
                if (s[l] >= s[l + 1]) break;
                t = s[l];
                s[l] = s[l + 1];
                s[l + 1] = t;
                if (wantv && l < p) {
                    Blas_f77.colswap_f77(p, v, l, l + 1);
                }
                if (wantu && l < n) {
                    Blas_f77.colswap_f77(n, u, l, l + 1);
                }
                ++l;
            }
            iter = 0;
            --m;
        }
        return;
    }
}

