/*
 * Decompiled with CFR 0.152.
 */
package optimization;

import optimization.Lmder_fcn;
import optimization.Lmdif_fcn;

public class Minpack_f77 {
    static final double epsmch = 2.22044604926E-16;
    static final double minmag = 2.2250738585200006E-308;
    static final double zero = 0.0;
    static final double one = 1.0;
    static final double p0001 = 1.0E-4;
    static final double p001 = 0.001;
    static final double p05 = 0.05;
    static final double p1 = 0.1;
    static final double p25 = 0.25;
    static final double p5 = 0.5;
    static final double p75 = 0.75;

    public static void lmder1_f77(Lmder_fcn nlls, int m, int n, double[] x, double[] fvec, double[][] fjac, double tol, int[] info, int[] ipvt) {
        int[] nfev = new int[2];
        int[] njev = new int[2];
        double[] diag = new double[n + 1];
        double[] qtf = new double[n + 1];
        double factor = 100.0;
        info[1] = 0;
        if (n <= 0 || m < n || tol < 0.0) {
            return;
        }
        int maxfev = 100 * (n + 1);
        double ftol = tol;
        double xtol = tol;
        double gtol = 0.0;
        int mode = 1;
        int nprint = 0;
        Minpack_f77.lmder_f77(nlls, m, n, x, fvec, fjac, ftol, xtol, gtol, maxfev, diag, mode, factor, nprint, info, nfev, njev, ipvt, qtf);
        if (info[1] == 8) {
            info[1] = 4;
        }
    }

    public static void lmder_f77(Lmder_fcn nlls, int m, int n, double[] x, double[] fvec, double[][] fjac, double ftol, double xtol, double gtol, int maxfev, double[] diag, int mode, double factor, int nprint, int[] info, int[] nfev, int[] njev, int[] ipvt, double[] qtf) {
        int j;
        double[] par = new double[2];
        int[] iflag = new int[2];
        double[] wa1 = new double[n + 1];
        double[] wa2 = new double[n + 1];
        double[] wa3 = new double[n + 1];
        double[] wa4 = new double[m + 1];
        double delta = 0.0;
        double xnorm = 0.0;
        info[1] = 0;
        iflag[1] = 0;
        nfev[1] = 0;
        njev[1] = 0;
        if (n <= 0 || m < n || ftol < 0.0 || xtol < 0.0 || gtol < 0.0 || maxfev <= 0 || factor <= 0.0) {
            if (nprint > 0) {
                nlls.fcn(m, n, x, fvec, fjac, iflag);
            }
            return;
        }
        if (mode == 2) {
            j = 1;
            while (j <= n) {
                if (diag[j] <= 0.0) {
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, fjac, iflag);
                    }
                    return;
                }
                ++j;
            }
        }
        iflag[1] = 1;
        nlls.fcn(m, n, x, fvec, fjac, iflag);
        nfev[1] = 1;
        if (iflag[1] < 0) {
            info[1] = iflag[1];
            iflag[1] = 0;
            if (nprint > 0) {
                nlls.fcn(m, n, x, fvec, fjac, iflag);
            }
            return;
        }
        double fnorm = Minpack_f77.enorm_f77(m, fvec);
        par[1] = 0.0;
        int iter = 1;
        boolean doneout = false;
        while (!doneout) {
            int l;
            double temp;
            double sum;
            iflag[1] = 2;
            nlls.fcn(m, n, x, fvec, fjac, iflag);
            njev[1] = njev[1] + 1;
            if (iflag[1] < 0) {
                info[1] = iflag[1];
                iflag[1] = 0;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, fjac, iflag);
                }
                return;
            }
            if (nprint > 0) {
                iflag[1] = 0;
                if ((iter - 1) % nprint == 0) {
                    nlls.fcn(m, n, x, fvec, fjac, iflag);
                }
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                    iflag[1] = 0;
                    nlls.fcn(m, n, x, fvec, fjac, iflag);
                    return;
                }
            }
            Minpack_f77.qrfac_f77(m, n, fjac, true, ipvt, wa1, wa2, wa3);
            if (iter == 1) {
                if (mode != 2) {
                    j = 1;
                    while (j <= n) {
                        diag[j] = wa2[j];
                        if (wa2[j] == 0.0) {
                            diag[j] = 1.0;
                        }
                        ++j;
                    }
                }
                j = 1;
                while (j <= n) {
                    wa3[j] = diag[j] * x[j];
                    ++j;
                }
                xnorm = Minpack_f77.enorm_f77(n, wa3);
                delta = factor * xnorm;
                if (delta == 0.0) {
                    delta = factor;
                }
            }
            int i = 1;
            while (i <= m) {
                wa4[i] = fvec[i];
                ++i;
            }
            j = 1;
            while (j <= n) {
                if (fjac[j][j] != 0.0) {
                    sum = 0.0;
                    i = j;
                    while (i <= m) {
                        sum += fjac[i][j] * wa4[i];
                        ++i;
                    }
                    temp = -sum / fjac[j][j];
                    i = j;
                    while (i <= m) {
                        int n2 = i;
                        wa4[n2] = wa4[n2] + fjac[i][j] * temp;
                        ++i;
                    }
                }
                fjac[j][j] = wa1[j];
                qtf[j] = wa4[j];
                ++j;
            }
            double gnorm = 0.0;
            if (fnorm != 0.0) {
                j = 1;
                while (j <= n) {
                    l = ipvt[j];
                    if (wa2[l] != 0.0) {
                        sum = 0.0;
                        i = 1;
                        while (i <= j) {
                            sum += fjac[i][j] * (qtf[i] / fnorm);
                            ++i;
                        }
                        gnorm = Math.max(gnorm, Math.abs(sum / wa2[l]));
                    }
                    ++j;
                }
            }
            if (gnorm <= gtol) {
                info[1] = 4;
            }
            if (info[1] != 0) {
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                }
                iflag[1] = 0;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, fjac, iflag);
                }
                return;
            }
            if (mode != 2) {
                j = 1;
                while (j <= n) {
                    diag[j] = Math.max(diag[j], wa2[j]);
                    ++j;
                }
            }
            boolean donein = false;
            while (!donein) {
                Minpack_f77.lmpar_f77(n, fjac, ipvt, diag, qtf, delta, par, wa1, wa2, wa3, wa4);
                j = 1;
                while (j <= n) {
                    wa1[j] = -wa1[j];
                    wa2[j] = x[j] + wa1[j];
                    wa3[j] = diag[j] * wa1[j];
                    ++j;
                }
                double pnorm = Minpack_f77.enorm_f77(n, wa3);
                if (iter == 1) {
                    delta = Math.min(delta, pnorm);
                }
                iflag[1] = 1;
                nlls.fcn(m, n, wa2, wa4, fjac, iflag);
                nfev[1] = nfev[1] + 1;
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, fjac, iflag);
                    }
                    return;
                }
                double fnorm1 = Minpack_f77.enorm_f77(m, wa4);
                double actred = -1.0;
                if (0.1 * fnorm1 < fnorm) {
                    actred = 1.0 - fnorm1 / fnorm * (fnorm1 / fnorm);
                }
                j = 1;
                while (j <= n) {
                    wa3[j] = 0.0;
                    l = ipvt[j];
                    temp = wa1[l];
                    i = 1;
                    while (i <= j) {
                        int n3 = i;
                        wa3[n3] = wa3[n3] + fjac[i][j] * temp;
                        ++i;
                    }
                    ++j;
                }
                double temp1 = Minpack_f77.enorm_f77(n, wa3) / fnorm;
                double temp2 = Math.sqrt(par[1]) * pnorm / fnorm;
                double prered = temp1 * temp1 + temp2 * temp2 / 0.5;
                double dirder = -(temp1 * temp1 + temp2 * temp2);
                double ratio = 0.0;
                if (prered != 0.0) {
                    ratio = actred / prered;
                }
                if (ratio <= 0.25) {
                    temp = actred >= 0.0 ? 0.5 : 0.5 * dirder / (dirder + 0.5 * actred);
                    if (0.1 * fnorm1 >= fnorm || temp < 0.1) {
                        temp = 0.1;
                    }
                    delta = temp * Math.min(delta, pnorm / 0.1);
                    par[1] = par[1] / temp;
                } else if (par[1] == 0.0 || ratio >= 0.75) {
                    delta = pnorm / 0.5;
                    par[1] = par[1] * 0.5;
                }
                if (ratio >= 1.0E-4) {
                    j = 1;
                    while (j <= n) {
                        x[j] = wa2[j];
                        wa2[j] = diag[j] * x[j];
                        ++j;
                    }
                    i = 1;
                    while (i <= m) {
                        fvec[i] = wa4[i];
                        ++i;
                    }
                    xnorm = Minpack_f77.enorm_f77(n, wa2);
                    fnorm = fnorm1;
                    ++iter;
                }
                if (Math.abs(actred) <= ftol && prered <= ftol && 0.5 * ratio <= 1.0) {
                    info[1] = 1;
                }
                if (delta <= xtol * xnorm) {
                    info[1] = 2;
                }
                if (Math.abs(actred) <= ftol && prered <= ftol && 0.5 * ratio <= 1.0 && info[1] == 2) {
                    info[1] = 3;
                }
                if (info[1] != 0) {
                    if (iflag[1] < 0) {
                        info[1] = iflag[1];
                    }
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, fjac, iflag);
                    }
                    return;
                }
                if (nfev[1] >= maxfev) {
                    info[1] = 5;
                }
                if (Math.abs(actred) <= 2.22044604926E-16 && prered <= 2.22044604926E-16 && 0.5 * ratio <= 1.0) {
                    info[1] = 6;
                }
                if (delta <= 2.22044604926E-16 * xnorm) {
                    info[1] = 7;
                }
                if (gnorm <= 2.22044604926E-16) {
                    info[1] = 8;
                }
                if (info[1] != 0) {
                    if (iflag[1] < 0) {
                        info[1] = iflag[1];
                    }
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, fjac, iflag);
                    }
                    return;
                }
                if (!(ratio >= 1.0E-4)) continue;
                donein = true;
            }
        }
    }

    public static double enorm_f77(int n, double[] x) {
        double rdwarf = 3.834000000000001E-20;
        double rgiant = 1.304E19;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double x1max = 0.0;
        double x3max = 0.0;
        double floatn = n;
        double agiant = rgiant / floatn;
        int i = 1;
        while (i <= n) {
            double xabs = Math.abs(x[i]);
            if (xabs <= rdwarf || xabs >= agiant) {
                if (xabs > rdwarf) {
                    if (xabs > x1max) {
                        s1 = 1.0 + s1 * (x1max / xabs) * (x1max / xabs);
                        x1max = xabs;
                    } else {
                        s1 += xabs / x1max * (xabs / x1max);
                    }
                } else if (xabs > x3max) {
                    s3 = 1.0 + s3 * (x3max / xabs) * (x3max / xabs);
                    x3max = xabs;
                } else if (xabs != 0.0) {
                    s3 += xabs / x3max * (xabs / x3max);
                }
            } else {
                s2 += xabs * xabs;
            }
            ++i;
        }
        double enorm = s1 != 0.0 ? x1max * Math.sqrt(s1 + s2 / x1max / x1max) : (s2 != 0.0 ? (s2 >= x3max ? Math.sqrt(s2 * (1.0 + x3max / s2 * (x3max * s3))) : Math.sqrt(x3max * (s2 / x3max + x3max * s3))) : x3max * Math.sqrt(s3));
        return enorm;
    }

    public static void qrfac_f77(int m, int n, double[][] a, boolean pivot, int[] ipvt, double[] rdiag, double[] acnorm, double[] wa) {
        int i;
        double[] tempvec = new double[m + 1];
        int j = 1;
        while (j <= n) {
            i = 1;
            while (i <= m) {
                tempvec[i] = a[i][j];
                ++i;
            }
            acnorm[j] = Minpack_f77.enorm_f77(m, tempvec);
            rdiag[j] = acnorm[j];
            wa[j] = rdiag[j];
            if (pivot) {
                ipvt[j] = j;
            }
            ++j;
        }
        int minmn = Math.min(m, n);
        j = 1;
        while (j <= minmn) {
            double temp;
            int k;
            if (pivot) {
                int kmax = j;
                k = j;
                while (k <= n) {
                    if (rdiag[k] > rdiag[kmax]) {
                        kmax = k;
                    }
                    ++k;
                }
                if (kmax != j) {
                    i = 1;
                    while (i <= m) {
                        temp = a[i][j];
                        a[i][j] = a[i][kmax];
                        a[i][kmax] = temp;
                        ++i;
                    }
                    rdiag[kmax] = rdiag[j];
                    wa[kmax] = wa[j];
                    k = ipvt[j];
                    ipvt[j] = ipvt[kmax];
                    ipvt[kmax] = k;
                }
            }
            i = j;
            while (i <= m) {
                tempvec[i - j + 1] = a[i][j];
                ++i;
            }
            double ajnorm = Minpack_f77.enorm_f77(m - j + 1, tempvec);
            if (ajnorm != 0.0) {
                if (a[j][j] < 0.0) {
                    ajnorm = -ajnorm;
                }
                i = j;
                while (i <= m) {
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] / ajnorm;
                    ++i;
                }
                double[] dArray = a[j];
                int n3 = j;
                dArray[n3] = dArray[n3] + 1.0;
                int jp1 = j + 1;
                if (n >= jp1) {
                    k = jp1;
                    while (k <= n) {
                        double sum = 0.0;
                        i = j;
                        while (i <= m) {
                            sum += a[i][j] * a[i][k];
                            ++i;
                        }
                        temp = sum / a[j][j];
                        i = j;
                        while (i <= m) {
                            double[] dArray2 = a[i];
                            int n4 = k;
                            dArray2[n4] = dArray2[n4] - temp * a[i][j];
                            ++i;
                        }
                        if (pivot && rdiag[k] != 0.0) {
                            temp = a[j][k] / rdiag[k];
                            int n5 = k;
                            rdiag[n5] = rdiag[n5] * Math.sqrt(Math.max(0.0, 1.0 - temp * temp));
                            double fac = rdiag[k] / wa[k];
                            if (0.05 * fac * fac <= 2.22044604926E-16) {
                                i = jp1;
                                while (i <= m) {
                                    tempvec[i - j] = a[i][k];
                                    ++i;
                                }
                                rdiag[k] = Minpack_f77.enorm_f77(m - j, tempvec);
                                wa[k] = rdiag[k];
                            }
                        }
                        ++k;
                    }
                }
            }
            rdiag[j] = -ajnorm;
            ++j;
        }
    }

    public static void qrsolv_f77(int n, double[][] r, int[] ipvt, double[] diag, double[] qtb, double[] x, double[] sdiag, double[] wa) {
        int k;
        int l;
        int i;
        int j = 1;
        while (j <= n) {
            i = j;
            while (i <= n) {
                r[i][j] = r[j][i];
                ++i;
            }
            x[j] = r[j][j];
            wa[j] = qtb[j];
            ++j;
        }
        j = 1;
        while (j <= n) {
            l = ipvt[j];
            if (diag[l] != 0.0) {
                k = j;
                while (k <= n) {
                    sdiag[k] = 0.0;
                    ++k;
                }
                sdiag[j] = diag[l];
                double qtbpj = 0.0;
                k = j;
                while (k <= n) {
                    if (sdiag[k] != 0.0) {
                        int kp1;
                        double cos;
                        double sin;
                        if (Math.abs(r[k][k]) < Math.abs(sdiag[k])) {
                            double cotan = r[k][k] / sdiag[k];
                            sin = 0.5 / Math.sqrt(0.25 + 0.25 * cotan * cotan);
                            cos = sin * cotan;
                        } else {
                            double tan = sdiag[k] / r[k][k];
                            cos = 0.5 / Math.sqrt(0.25 + 0.25 * tan * tan);
                            sin = cos * tan;
                        }
                        r[k][k] = cos * r[k][k] + sin * sdiag[k];
                        double temp = cos * wa[k] + sin * qtbpj;
                        qtbpj = -sin * wa[k] + cos * qtbpj;
                        wa[k] = temp;
                        i = kp1 = k + 1;
                        while (i <= n) {
                            temp = cos * r[i][k] + sin * sdiag[i];
                            sdiag[i] = -sin * r[i][k] + cos * sdiag[i];
                            r[i][k] = temp;
                            ++i;
                        }
                    }
                    ++k;
                }
            }
            sdiag[j] = r[j][j];
            r[j][j] = x[j];
            ++j;
        }
        int nsing = n;
        j = 1;
        while (j <= n) {
            if (sdiag[j] == 0.0 && nsing == n) {
                nsing = j - 1;
            }
            if (nsing < n) {
                wa[j] = 0.0;
            }
            ++j;
        }
        k = 1;
        while (k <= nsing) {
            int jp1;
            j = nsing - k + 1;
            double sum = 0.0;
            i = jp1 = j + 1;
            while (i <= nsing) {
                sum += r[i][j] * wa[i];
                ++i;
            }
            wa[j] = (wa[j] - sum) / sdiag[j];
            ++k;
        }
        j = 1;
        while (j <= n) {
            l = ipvt[j];
            x[l] = wa[j];
            ++j;
        }
    }

    public static void lmpar_f77(int n, double[][] r, int[] ipvt, double[] diag, double[] qtb, double delta, double[] par, double[] x, double[] sdiag, double[] wa1, double[] wa2) {
        double sum;
        int l;
        int i;
        int jm1;
        double temp;
        double dwarf = 2.2250738585200006E-308;
        int nsing = n;
        int j = 1;
        while (j <= n) {
            wa1[j] = qtb[j];
            if (r[j][j] == 0.0 && nsing == n) {
                nsing = j - 1;
            }
            if (nsing < n) {
                wa1[j] = 0.0;
            }
            ++j;
        }
        int k = 1;
        while (k <= nsing) {
            int n2 = j = nsing - k + 1;
            wa1[n2] = wa1[n2] / r[j][j];
            temp = wa1[j];
            jm1 = j - 1;
            i = 1;
            while (i <= jm1) {
                int n3 = i;
                wa1[n3] = wa1[n3] - r[i][j] * temp;
                ++i;
            }
            ++k;
        }
        j = 1;
        while (j <= n) {
            l = ipvt[j];
            x[l] = wa1[j];
            ++j;
        }
        int iter = 0;
        j = 1;
        while (j <= n) {
            wa2[j] = diag[j] * x[j];
            ++j;
        }
        double dxnorm = Minpack_f77.enorm_f77(n, wa2);
        double fp = dxnorm - delta;
        if (fp <= 0.1 * delta) {
            par[1] = 0.0;
            return;
        }
        double parl = 0.0;
        if (nsing >= n) {
            j = 1;
            while (j <= n) {
                l = ipvt[j];
                wa1[j] = diag[l] * (wa2[l] / dxnorm);
                ++j;
            }
            j = 1;
            while (j <= n) {
                sum = 0.0;
                jm1 = j - 1;
                i = 1;
                while (i <= jm1) {
                    sum += r[i][j] * wa1[i];
                    ++i;
                }
                wa1[j] = (wa1[j] - sum) / r[j][j];
                ++j;
            }
            temp = Minpack_f77.enorm_f77(n, wa1);
            parl = fp / delta / temp / temp;
        }
        j = 1;
        while (j <= n) {
            sum = 0.0;
            i = 1;
            while (i <= j) {
                sum += r[i][j] * qtb[i];
                ++i;
            }
            l = ipvt[j];
            wa1[j] = sum / diag[l];
            ++j;
        }
        double gnorm = Minpack_f77.enorm_f77(n, wa1);
        double paru = gnorm / delta;
        if (paru == 0.0) {
            paru = dwarf / Math.min(delta, 0.1);
        }
        par[1] = Math.max(par[1], parl);
        par[1] = Math.min(par[1], paru);
        if (par[1] == 0.0) {
            par[1] = gnorm / dxnorm;
        }
        boolean loop = true;
        while (loop) {
            ++iter;
            if (par[1] == 0.0) {
                par[1] = Math.max(dwarf, 0.001 * paru);
            }
            temp = Math.sqrt(par[1]);
            j = 1;
            while (j <= n) {
                wa1[j] = temp * diag[j];
                ++j;
            }
            Minpack_f77.qrsolv_f77(n, r, ipvt, wa1, qtb, x, sdiag, wa2);
            j = 1;
            while (j <= n) {
                wa2[j] = diag[j] * x[j];
                ++j;
            }
            dxnorm = Minpack_f77.enorm_f77(n, wa2);
            temp = fp;
            fp = dxnorm - delta;
            if (Math.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= temp && temp < 0.0 || iter == 10) {
                if (iter == 0) {
                    par[1] = 0.0;
                }
                return;
            }
            j = 1;
            while (j <= n) {
                l = ipvt[j];
                wa1[j] = diag[l] * (wa2[l] / dxnorm);
                ++j;
            }
            j = 1;
            while (j <= n) {
                int jp1;
                int n4 = j;
                wa1[n4] = wa1[n4] / sdiag[j];
                temp = wa1[j];
                i = jp1 = j + 1;
                while (i <= n) {
                    int n5 = i;
                    wa1[n5] = wa1[n5] - r[i][j] * temp;
                    ++i;
                }
                ++j;
            }
            temp = Minpack_f77.enorm_f77(n, wa1);
            double parc = fp / delta / temp / temp;
            if (fp > 0.0) {
                parl = Math.max(parl, par[1]);
            }
            if (fp < 0.0) {
                paru = Math.min(paru, par[1]);
            }
            par[1] = Math.max(parl, par[1] + parc);
        }
    }

    public static void lmdif1_f77(Lmdif_fcn nlls, int m, int n, double[] x, double[] fvec, double tol, int[] info) {
        double[] diag = new double[n + 1];
        int[] nfev = new int[2];
        double[][] fjac = new double[m + 1][n + 1];
        int[] ipvt = new int[n + 1];
        double[] qtf = new double[n + 1];
        double factor = 100.0;
        info[1] = 0;
        if (n <= 0 || m < n || tol < 0.0) {
            return;
        }
        int maxfev = 200 * (n + 1);
        double ftol = tol;
        double xtol = tol;
        double gtol = 0.0;
        double epsfcn = 0.0;
        int mode = 1;
        int nprint = 0;
        Minpack_f77.lmdif_f77(nlls, m, n, x, fvec, ftol, xtol, gtol, maxfev, epsfcn, diag, mode, factor, nprint, info, nfev, fjac, ipvt, qtf);
        if (info[1] == 8) {
            info[1] = 4;
        }
    }

    public static void lmdif2_f77(Lmdif_fcn nlls, int m, int n, double[] x, double[] fvec, double tol, double epsiFinDiff, int[] info) {
        double[] diag = new double[n + 1];
        int[] nfev = new int[2];
        double[][] fjac = new double[m + 1][n + 1];
        int[] ipvt = new int[n + 1];
        double[] qtf = new double[n + 1];
        double factor = 100.0;
        info[1] = 0;
        if (n <= 0 || m < n || tol < 0.0) {
            return;
        }
        int maxfev = 200 * (n + 1);
        double ftol = tol;
        double xtol = tol;
        double gtol = 0.0;
        double epsfcn = epsiFinDiff;
        int mode = 1;
        int nprint = 0;
        Minpack_f77.lmdif_f77(nlls, m, n, x, fvec, ftol, xtol, gtol, maxfev, epsfcn, diag, mode, factor, nprint, info, nfev, fjac, ipvt, qtf);
        if (info[1] == 8) {
            info[1] = 4;
        }
    }

    public static void lmdif_f77(Lmdif_fcn nlls, int m, int n, double[] x, double[] fvec, double ftol, double xtol, double gtol, int maxfev, double epsfcn, double[] diag, int mode, double factor, int nprint, int[] info, int[] nfev, double[][] fjac, int[] ipvt, double[] qtf) {
        int j;
        double[] par = new double[2];
        int[] iflag = new int[2];
        double[] wa1 = new double[n + 1];
        double[] wa2 = new double[n + 1];
        double[] wa3 = new double[n + 1];
        double[] wa4 = new double[m + 1];
        double delta = 0.0;
        double xnorm = 0.0;
        info[1] = 0;
        iflag[1] = 0;
        nfev[1] = 0;
        if (n <= 0 || m < n || ftol < 0.0 || xtol < 0.0 || gtol < 0.0 || maxfev <= 0 || factor <= 0.0) {
            if (nprint > 0) {
                nlls.fcn(m, n, x, fvec, iflag);
            }
            return;
        }
        if (mode == 2) {
            j = 1;
            while (j <= n) {
                if (diag[j] <= 0.0) {
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, iflag);
                    }
                    return;
                }
                ++j;
            }
        }
        iflag[1] = 1;
        nlls.fcn(m, n, x, fvec, iflag);
        nfev[1] = 1;
        if (iflag[1] < 0) {
            info[1] = iflag[1];
            iflag[1] = 0;
            if (nprint > 0) {
                nlls.fcn(m, n, x, fvec, iflag);
            }
            return;
        }
        double fnorm = Minpack_f77.enorm_f77(m, fvec);
        par[1] = 0.0;
        int iter = 1;
        boolean doneout = false;
        while (!doneout) {
            int l;
            double temp;
            double sum;
            iflag[1] = 2;
            Minpack_f77.fdjac2_f77(nlls, m, n, x, fvec, fjac, iflag, epsfcn, wa4);
            nfev[1] = nfev[1] + n;
            if (iflag[1] < 0) {
                info[1] = iflag[1];
                iflag[1] = 0;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, iflag);
                }
                return;
            }
            if (nprint > 0) {
                iflag[1] = 0;
                if ((iter - 1) % nprint == 0) {
                    nlls.fcn(m, n, x, fvec, iflag);
                }
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                    iflag[1] = 0;
                    nlls.fcn(m, n, x, fvec, iflag);
                    return;
                }
            }
            Minpack_f77.qrfac_f77(m, n, fjac, true, ipvt, wa1, wa2, wa3);
            if (iter == 1) {
                if (mode != 2) {
                    j = 1;
                    while (j <= n) {
                        diag[j] = wa2[j];
                        if (wa2[j] == 0.0) {
                            diag[j] = 1.0;
                        }
                        ++j;
                    }
                }
                j = 1;
                while (j <= n) {
                    wa3[j] = diag[j] * x[j];
                    ++j;
                }
                xnorm = Minpack_f77.enorm_f77(n, wa3);
                delta = factor * xnorm;
                if (delta == 0.0) {
                    delta = factor;
                }
            }
            int i = 1;
            while (i <= m) {
                wa4[i] = fvec[i];
                ++i;
            }
            j = 1;
            while (j <= n) {
                if (fjac[j][j] != 0.0) {
                    sum = 0.0;
                    i = j;
                    while (i <= m) {
                        sum += fjac[i][j] * wa4[i];
                        ++i;
                    }
                    temp = -sum / fjac[j][j];
                    i = j;
                    while (i <= m) {
                        int n2 = i;
                        wa4[n2] = wa4[n2] + fjac[i][j] * temp;
                        ++i;
                    }
                }
                fjac[j][j] = wa1[j];
                qtf[j] = wa4[j];
                ++j;
            }
            double gnorm = 0.0;
            if (fnorm != 0.0) {
                j = 1;
                while (j <= n) {
                    l = ipvt[j];
                    if (wa2[l] != 0.0) {
                        sum = 0.0;
                        i = 1;
                        while (i <= j) {
                            sum += fjac[i][j] * (qtf[i] / fnorm);
                            ++i;
                        }
                        gnorm = Math.max(gnorm, Math.abs(sum / wa2[l]));
                    }
                    ++j;
                }
            }
            if (gnorm <= gtol) {
                info[1] = 4;
            }
            if (info[1] != 0) {
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                }
                iflag[1] = 0;
                if (nprint > 0) {
                    nlls.fcn(m, n, x, fvec, iflag);
                }
                return;
            }
            if (mode != 2) {
                j = 1;
                while (j <= n) {
                    diag[j] = Math.max(diag[j], wa2[j]);
                    ++j;
                }
            }
            boolean donein = false;
            while (!donein) {
                Minpack_f77.lmpar_f77(n, fjac, ipvt, diag, qtf, delta, par, wa1, wa2, wa3, wa4);
                j = 1;
                while (j <= n) {
                    wa1[j] = -wa1[j];
                    wa2[j] = x[j] + wa1[j];
                    wa3[j] = diag[j] * wa1[j];
                    ++j;
                }
                double pnorm = Minpack_f77.enorm_f77(n, wa3);
                if (iter == 1) {
                    delta = Math.min(delta, pnorm);
                }
                iflag[1] = 1;
                nlls.fcn(m, n, wa2, wa4, iflag);
                nfev[1] = nfev[1] + 1;
                if (iflag[1] < 0) {
                    info[1] = iflag[1];
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, iflag);
                    }
                    return;
                }
                double fnorm1 = Minpack_f77.enorm_f77(m, wa4);
                double actred = -1.0;
                if (0.1 * fnorm1 < fnorm) {
                    actred = 1.0 - fnorm1 / fnorm * (fnorm1 / fnorm);
                }
                j = 1;
                while (j <= n) {
                    wa3[j] = 0.0;
                    l = ipvt[j];
                    temp = wa1[l];
                    i = 1;
                    while (i <= j) {
                        int n3 = i;
                        wa3[n3] = wa3[n3] + fjac[i][j] * temp;
                        ++i;
                    }
                    ++j;
                }
                double temp1 = Minpack_f77.enorm_f77(n, wa3) / fnorm;
                double temp2 = Math.sqrt(par[1]) * pnorm / fnorm;
                double prered = temp1 * temp1 + temp2 * temp2 / 0.5;
                double dirder = -(temp1 * temp1 + temp2 * temp2);
                double ratio = 0.0;
                if (prered != 0.0) {
                    ratio = actred / prered;
                }
                if (ratio <= 0.25) {
                    temp = actred >= 0.0 ? 0.5 : 0.5 * dirder / (dirder + 0.5 * actred);
                    if (0.1 * fnorm1 >= fnorm || temp < 0.1) {
                        temp = 0.1;
                    }
                    delta = temp * Math.min(delta, pnorm / 0.1);
                    par[1] = par[1] / temp;
                } else if (par[1] == 0.0 || ratio >= 0.75) {
                    delta = pnorm / 0.5;
                    par[1] = par[1] * 0.5;
                }
                if (ratio >= 1.0E-4) {
                    j = 1;
                    while (j <= n) {
                        x[j] = wa2[j];
                        wa2[j] = diag[j] * x[j];
                        ++j;
                    }
                    i = 1;
                    while (i <= m) {
                        fvec[i] = wa4[i];
                        ++i;
                    }
                    xnorm = Minpack_f77.enorm_f77(n, wa2);
                    fnorm = fnorm1;
                    ++iter;
                }
                if (Math.abs(actred) <= ftol && prered <= ftol && 0.5 * ratio <= 1.0) {
                    info[1] = 1;
                }
                if (delta <= xtol * xnorm) {
                    info[1] = 2;
                }
                if (Math.abs(actred) <= ftol && prered <= ftol && 0.5 * ratio <= 1.0 && info[1] == 2) {
                    info[1] = 3;
                }
                if (info[1] != 0) {
                    if (iflag[1] < 0) {
                        info[1] = iflag[1];
                    }
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, iflag);
                    }
                    return;
                }
                if (nfev[1] >= maxfev) {
                    info[1] = 5;
                }
                if (Math.abs(actred) <= 2.22044604926E-16 && prered <= 2.22044604926E-16 && 0.5 * ratio <= 1.0) {
                    info[1] = 6;
                }
                if (delta <= 2.22044604926E-16 * xnorm) {
                    info[1] = 7;
                }
                if (gnorm <= 2.22044604926E-16) {
                    info[1] = 8;
                }
                if (info[1] != 0) {
                    if (iflag[1] < 0) {
                        info[1] = iflag[1];
                    }
                    iflag[1] = 0;
                    if (nprint > 0) {
                        nlls.fcn(m, n, x, fvec, iflag);
                    }
                    return;
                }
                if (!(ratio >= 1.0E-4)) continue;
                donein = true;
            }
        }
    }

    public static void fdjac2_f77(Lmdif_fcn nlls, int m, int n, double[] x, double[] fvec, double[][] fjac, int[] iflag, double epsfcn, double[] wa) {
        double eps = Math.sqrt(Math.max(epsfcn, 2.22044604926E-16));
        int j = 1;
        while (j <= n) {
            double temp = x[j];
            double h = eps * Math.abs(temp);
            if (h == 0.0) {
                h = eps;
            }
            x[j] = temp + h;
            nlls.fcn(m, n, x, wa, iflag);
            if (iflag[1] < 0) {
                return;
            }
            x[j] = temp;
            int i = 1;
            while (i <= m) {
                fjac[i][j] = (wa[i] - fvec[i]) / h;
                ++i;
            }
            ++j;
        }
    }
}

