/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;

public class CmdCopy
extends Cmd {
    public void doIt() {
        Editor editor = Globals.curEditor();
        Vector vector = editor.getSelectionManager().selections();
        Vector<Fig> vector2 = new Vector<Fig>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Selection selection = (Selection)enumeration.nextElement();
            Fig fig = selection.getContent();
            if (fig instanceof FigEdge) continue;
            fig = (Fig)fig.clone();
            vector2.addElement(fig);
        }
        Globals.clipBoard = vector2;
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdCopy");
    }

    public CmdCopy() {
        super("Copy");
    }

    static class SimpleSelection
    implements Transferable,
    ClipboardOwner {
        protected Fig selection;
        protected DataFlavor flavor;

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(this.flavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (dataFlavor.equals(this.flavor)) {
                return this.selection;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            this.selection = null;
        }

        public SimpleSelection(Fig fig, DataFlavor dataFlavor) {
            this.selection = fig;
            this.flavor = dataFlavor;
        }
    }
}

