/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import org.tigris.gef.base.CmdSaveGraphics;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.TransFilter;

public class CmdSaveGIF
extends CmdSaveGraphics {
    public static final int TRANSPARENT_BG_COLOR = 0xEFEFEF;

    protected void saveGraphics(OutputStream outputStream, Editor editor, Rectangle rectangle) throws IOException {
        Image image = editor.createImage(rectangle.width, rectangle.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(new Color(0xEFEFEF));
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.translate(-rectangle.x, -rectangle.y);
        editor.print(graphics);
        try {
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new TransFilter(0xEFEFEF));
            GifEncoder gifEncoder = new GifEncoder((ImageProducer)filteredImageSource, outputStream);
            gifEncoder.encode();
        }
        catch (IOException iOException) {
            System.out.println("GifEncoder failed: " + iOException);
        }
        graphics.dispose();
        graphics = null;
    }

    public CmdSaveGIF() {
        super("Save GIF...", false);
    }
}

