/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.Vector;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;

public class LayerGrid
extends Layer {
    private int _spacing = 16;
    private boolean _paintLines = false;
    private transient Image _stamp = null;
    private int _stampWidth = 128;
    private int _stampHeight = 128;
    protected Color _color = new Color(180, 180, 180);
    protected Color _bgColor = Color.lightGray;
    protected boolean _paintBackground = true;
    protected int _dotSize = 2;
    private int _style = 2;
    private final int NUM_STYLES;

    public Vector getContents() {
        return null;
    }

    public Fig presentationFor(Object object) {
        return null;
    }

    public synchronized void paintContents(Graphics graphics) {
        Serializable serializable;
        if (graphics instanceof PrintGraphics) {
            if (!Globals.getPrefs().getPrintGrid()) {
                return;
            }
            if (this._paintLines) {
                this.paintLines(graphics, Globals.getPrefs().getPrintBackground());
            } else {
                this.paintDots(graphics, Globals.getPrefs().getPrintBackground());
            }
            return;
        }
        if (this._stamp == null) {
            if (this._spacing > this._stampHeight) {
                this._stampHeight = this._stampWidth = this._spacing;
            }
            if (Globals.curEditor() == null) {
                System.out.println("no editor");
                serializable = new Frame();
                ((Window)serializable).show();
                this._stamp = ((Component)serializable).createImage(this._stampWidth, this._stampHeight);
                ((Window)serializable).dispose();
            } else {
                this._stamp = Globals.curEditor().createImage(this._stampWidth, this._stampHeight);
            }
            if (this._stamp != null) {
                if (this._paintLines) {
                    this.paintLines(this._stamp, this._paintBackground);
                } else {
                    this.paintDots(this._stamp, this._paintBackground);
                }
            }
        }
        serializable = graphics.getClipBounds();
        int n = ((Rectangle)serializable).x / this._spacing * this._spacing;
        int n2 = ((Rectangle)serializable).y / this._spacing * this._spacing;
        int n3 = ((Rectangle)serializable).y + ((Rectangle)serializable).height;
        int n4 = ((Rectangle)serializable).x + ((Rectangle)serializable).width;
        if (this._stamp != null) {
            while (n <= n4) {
                n2 = ((Rectangle)serializable).y / this._spacing * this._spacing;
                while (n2 <= n3) {
                    graphics.drawImage(this._stamp, n, n2, null);
                    n2 += this._stampHeight;
                }
                n += this._stampWidth;
            }
        }
    }

    private void paintLines(Image image, boolean bl) {
        Graphics graphics = image.getGraphics();
        graphics.clipRect(0, 0, image.getWidth(null), image.getHeight(null));
        this.paintLines(graphics, bl);
    }

    private void paintDots(Image image, boolean bl) {
        Graphics graphics = image.getGraphics();
        graphics.clipRect(0, 0, image.getWidth(null), image.getHeight(null));
        this.paintDots(graphics, bl);
    }

    private void paintLines(Graphics graphics, boolean bl) {
        Rectangle rectangle = graphics.getClipBounds();
        if (bl) {
            graphics.setColor(this._bgColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int n = rectangle.x / this._spacing * this._spacing - this._spacing;
        int n2 = rectangle.y / this._spacing * this._spacing - this._spacing;
        int n3 = rectangle.width / this._spacing + 2;
        int n4 = rectangle.height / this._spacing + 2;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.y + rectangle.height;
        graphics.setColor(this._color);
        while (n3 > 0) {
            graphics.drawLine(n, 0, n, n6);
            n += this._spacing;
            --n3;
        }
        while (n4 > 0) {
            graphics.drawLine(0, n2, n5, n2);
            n2 += this._spacing;
            --n4;
        }
    }

    protected void paintDots(Graphics graphics, boolean bl) {
        Rectangle rectangle = graphics.getClipBounds();
        if (bl) {
            graphics.setColor(this._bgColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int n = rectangle.x / this._spacing * this._spacing - this._spacing;
        int n2 = rectangle.y / this._spacing * this._spacing - this._spacing;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        graphics.setColor(this._color);
        while (n <= n3) {
            n2 = 0;
            while (n2 <= n4) {
                graphics.fillRect(n, n2, this._dotSize, this._dotSize);
                n2 += this._spacing;
            }
            n += this._spacing;
        }
    }

    public void adjust() {
        this._style = (this._style + 1) % 5;
        this._stamp = null;
        switch (this._style) {
            case 0: {
                this.setHidden(false);
                this._paintLines = true;
                this._spacing = 16;
                break;
            }
            case 1: {
                this.setHidden(false);
                this._paintLines = true;
                this._spacing = 8;
                break;
            }
            case 2: {
                this.setHidden(false);
                this._paintLines = false;
                this._spacing = 16;
                break;
            }
            case 3: {
                this.setHidden(false);
                this._paintLines = false;
                this._spacing = 32;
                break;
            }
            case 4: {
                this.setHidden(true);
                break;
            }
        }
        this.refreshEditors();
    }

    public LayerGrid() {
        super("Grid");
        this.NUM_STYLES = 5;
    }

    public LayerGrid(Color color, Color color2, int n, boolean bl) {
        super("Grid");
        this.NUM_STYLES = 5;
        this._color = color;
        this._bgColor = color2;
        this._spacing = n;
        this._paintLines = bl;
    }
}

