/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.MouseEvent;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigNode;

public class ModeCreateEdge
extends ModeCreate {
    private Object _startPort;
    private Fig _startPortFig;
    private FigNode _sourceFigNode;
    private Object _newEdge;

    public String instructions() {
        return "Drag to define an edge to another port";
    }

    public Fig createNewItem(MouseEvent mouseEvent, int n, int n2) {
        return new FigLine(n, n2, 0, 0, Globals.getPrefs().getRubberbandColor());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Editor editor = Globals.curEditor();
        Fig fig = editor.hit(n, n2);
        if (fig == null) {
            fig = editor.hit(n - 16, n2 - 16, 32, 32);
        }
        if (fig == null) {
            this.done();
            mouseEvent.consume();
            return;
        }
        if (!(fig instanceof FigNode)) {
            this.done();
            mouseEvent.consume();
            return;
        }
        this._sourceFigNode = (FigNode)fig;
        this._startPort = this._sourceFigNode.deepHitPort(n, n2);
        if (this._startPort == null) {
            this.done();
            mouseEvent.consume();
            return;
        }
        this._startPortFig = this._sourceFigNode.getPortFig(this._startPort);
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        FigNode figNode;
        Object object;
        GraphModel graphModel;
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._sourceFigNode == null) {
            this.done();
            mouseEvent.consume();
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Editor editor = Globals.curEditor();
        Fig fig = editor.hit(n, n2);
        if (fig == null) {
            fig = editor.hit(n - 16, n2 - 16, 32, 32);
        }
        if (!((graphModel = editor.getGraphModel()) instanceof MutableGraphModel)) {
            fig = null;
        }
        MutableGraphModel mutableGraphModel = (MutableGraphModel)graphModel;
        if (fig instanceof FigNode && (object = (figNode = (FigNode)fig).deepHitPort(n, n2)) != null && object != this._startPort) {
            Fig fig2 = figNode.getPortFig(object);
            Class clazz = (Class)this.getArg("edgeClass");
            this._newEdge = clazz != null ? mutableGraphModel.connect(this._startPort, object, clazz) : mutableGraphModel.connect(this._startPort, object);
            if (this._newEdge != null) {
                LayerManager layerManager = editor.getLayerManager();
                editor.damaged(this._newItem);
                this._sourceFigNode.damage();
                figNode.damage();
                this._newItem = null;
                FigEdge figEdge = (FigEdge)editor.getLayerManager().getActiveLayer().presentationFor(this._newEdge);
                figEdge.setSourcePortFig(this._startPortFig);
                figEdge.setSourceFigNode(this._sourceFigNode);
                figEdge.setDestPortFig(fig2);
                figEdge.setDestFigNode(figNode);
                if (figEdge != null) {
                    editor.getSelectionManager().select(figEdge);
                }
                this.done();
                mouseEvent.consume();
                return;
            }
            System.out.println("connection return null");
        }
        this._sourceFigNode.damage();
        editor.damaged(this._newItem);
        this._newItem = null;
        this.done();
        mouseEvent.consume();
    }

    public ModeCreateEdge() {
    }

    public ModeCreateEdge(Editor editor) {
        super(editor);
    }
}

