/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigText;

public class FigGroup
extends Fig {
    protected Vector _figs;
    public String _dynObjects;

    public void parseDynObjects(String string) {
    }

    public void addFig(Fig fig) {
        this._figs.addElement(fig);
        fig.setGroup(this);
        this.calcBounds();
    }

    public void calcBounds() {
        Enumeration enumeration = this._figs.elements();
        Rectangle rectangle = enumeration.hasMoreElements() ? ((Fig)enumeration.nextElement()).getBounds() : new Rectangle(0, 0, 0, 0);
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            rectangle.add(fig.getBounds());
        }
        this._x = rectangle.x;
        this._y = rectangle.y;
        this._w = rectangle.width;
        this._h = rectangle.height;
    }

    public Object clone() {
        FigGroup figGroup = (FigGroup)super.clone();
        Vector<Fig> vector = new Vector<Fig>(this._figs.size());
        Enumeration enumeration = this._figs.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            Fig fig2 = (Fig)fig.clone();
            vector.addElement(fig2);
            fig2.setGroup(figGroup);
        }
        figGroup._figs = vector;
        return figGroup;
    }

    public boolean contains(int n, int n2) {
        return this.hitFig(new Rectangle(n, n2, 0, 0)) != null;
    }

    public Enumeration elements() {
        return this._figs.elements();
    }

    public Vector getFigs() {
        return this._figs;
    }

    public Color getFillColor() {
        if (this._figs.size() == 0) {
            return super.getFillColor();
        }
        return ((Fig)this._figs.elementAt(this._figs.size() - 1)).getFillColor();
    }

    public boolean getFilled() {
        if (this._figs.size() == 0) {
            return super.getFilled();
        }
        return ((Fig)this._figs.elementAt(this._figs.size() - 1)).getFilled();
    }

    public Font getFont() {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                return ((FigText)e).getFont();
            }
            ++n2;
        }
        return null;
    }

    public String getFontFamily() {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                return ((FigText)e).getFontFamily();
            }
            ++n2;
        }
        return "Serif";
    }

    public int getFontSize() {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                return ((FigText)e).getFontSize();
            }
            ++n2;
        }
        return 10;
    }

    public Color getLineColor() {
        if (this._figs.size() == 0) {
            return super.getLineColor();
        }
        return ((Fig)this._figs.elementAt(this._figs.size() - 1)).getLineColor();
    }

    public int getLineWidth() {
        if (this._figs.size() == 0) {
            return super.getLineWidth();
        }
        return ((Fig)this._figs.elementAt(this._figs.size() - 1)).getLineWidth();
    }

    public String getPrivateData() {
        Fig fig = this.getEnclosingFig();
        if (fig != null) {
            return "enclosingFig=\"" + fig.getId() + "\"";
        }
        return "";
    }

    public Color getTextColor() {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                return ((FigText)e).getTextColor();
            }
            ++n2;
        }
        return null;
    }

    public Color getTextFillColor() {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                return ((FigText)e).getTextFillColor();
            }
            ++n2;
        }
        return null;
    }

    public boolean getTextFilled() {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                return ((FigText)e).getTextFilled();
            }
            ++n2;
        }
        return false;
    }

    public boolean hit(Rectangle rectangle) {
        return this.hitFig(rectangle) != null;
    }

    public Fig hitFig(Rectangle rectangle) {
        Enumeration enumeration = this.elements();
        Fig fig = null;
        while (enumeration.hasMoreElements()) {
            Fig fig2 = (Fig)enumeration.nextElement();
            if (!fig2.hit(rectangle)) continue;
            fig = fig2;
        }
        return fig;
    }

    public boolean isReshapable() {
        return false;
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isRotatable() {
        return false;
    }

    public void paint(Graphics graphics) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            fig.paint(graphics);
        }
    }

    public void removeAll() {
        Rectangle rectangle = this.getBounds();
        int n = 0;
        while (n < this._figs.size()) {
            Fig fig = (Fig)this._figs.elementAt(n);
            fig.setGroup(null);
            ++n;
        }
        this._figs.removeAllElements();
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public void removeFig(Fig fig) {
        if (!this._figs.contains(fig)) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        this._figs.removeElement(fig);
        fig.setGroup(null);
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        Enumeration enumeration = this._figs.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            int n5 = this._w == 0 ? n : n + (fig.getX() - this._x) * n3 / this._w;
            int n6 = this._h == 0 ? n2 : n2 + (fig.getY() - this._y) * n4 / this._h;
            int n7 = this._w == 0 ? 0 : fig.getWidth() * n3 / this._w;
            int n8 = this._h == 0 ? 0 : fig.getHeight() * n4 / this._h;
            fig.setBounds(n5, n6, n7, n8);
        }
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public void setFigs(Vector vector) {
        Rectangle rectangle = this.getBounds();
        this._figs = vector;
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public void setFillColor(Color color) {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            ((Fig)this._figs.elementAt(n2)).setFillColor(color);
            ++n2;
        }
    }

    public void setFilled(boolean bl) {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            ((Fig)this._figs.elementAt(n2)).setFilled(bl);
            ++n2;
        }
    }

    public void setFont(Font font) {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                ((FigText)e).setFont(font);
            }
            ++n2;
        }
    }

    public void setFontFamily(String string) {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                ((FigText)e).setFontFamily(string);
            }
            ++n2;
        }
    }

    public void setFontSize(int n) {
        int n2 = this._figs.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = this._figs.elementAt(n3);
            if (e instanceof FigText) {
                ((FigText)e).setFontSize(n);
            }
            ++n3;
        }
    }

    public void setLineColor(Color color) {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            ((Fig)this._figs.elementAt(n2)).setLineColor(color);
            ++n2;
        }
    }

    public void setLineWidth(int n) {
        int n2 = this._figs.size();
        int n3 = 0;
        while (n3 < n2) {
            ((Fig)this._figs.elementAt(n3)).setLineWidth(n);
            ++n3;
        }
    }

    public void setPrivateData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=\"' ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("enclosingFig")) continue;
            String string3 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string3);
        }
    }

    public void setTextColor(Color color) {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                ((FigText)e).setTextColor(color);
            }
            ++n2;
        }
    }

    public void setTextFillColor(Color color) {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                ((FigText)e).setTextFillColor(color);
            }
            ++n2;
        }
    }

    public void setTextFilled(boolean bl) {
        int n = this._figs.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this._figs.elementAt(n2);
            if (e instanceof FigText) {
                ((FigText)e).setTextFilled(bl);
            }
            ++n2;
        }
    }

    public void translate(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        Enumeration enumeration = this._figs.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            fig.translate(n, n2);
        }
        this._x += n;
        this._y += n2;
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public FigGroup() {
        this._figs = new Vector();
    }

    public FigGroup(Vector vector) {
        this._figs = vector;
        this.calcBounds();
    }
}

