/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RectangleEditor
extends JPanel
implements PropertyEditor {
    protected Rectangle _rect = null;
    private Vector listeners;
    protected JTextField xField;
    protected JTextField yField;
    protected JTextField wField;
    protected JTextField hField;

    public void setValue(Object object) {
        if (!(object instanceof Rectangle)) {
            return;
        }
        this._rect = (Rectangle)object;
        this.updateWidgets();
    }

    public Object getValue() {
        return this._rect;
    }

    public String getJavaInitializationString() {
        return "new Rectangle(" + this.getAsText() + ")";
    }

    public String getAsText() {
        Rectangle rectangle = (Rectangle)this.getValue();
        return "" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height;
    }

    public void setAsText(String string) {
    }

    public String[] getTags() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = (Rectangle)this.getValue();
        String string = "(" + rectangle2.x + "," + rectangle2.y + ")+(" + rectangle2.width + "x" + rectangle2.height + " )";
        graphics.drawString(string, rectangle.x + 2, rectangle.x + rectangle.height - 4);
    }

    public void setEnable(boolean bl) {
        this.xField.setEditable(bl);
        this.yField.setEditable(bl);
        this.wField.setEditable(bl);
        this.hField.setEditable(bl);
    }

    public void updateWidgets() {
        this.xField.setText(Integer.toString(this._rect.x));
        this.yField.setText(Integer.toString(this._rect.y));
        this.wField.setText(Integer.toString(this._rect.width));
        this.hField.setText(Integer.toString(this._rect.height));
    }

    protected void readFields() {
        try {
            int n = Integer.parseInt(this.xField.getText());
            int n2 = Integer.parseInt(this.yField.getText());
            int n3 = Integer.parseInt(this.wField.getText());
            int n4 = Integer.parseInt(this.hField.getText());
            this.setValue(new Rectangle(n, n2, n3, n4));
        }
        catch (NumberFormatException numberFormatException) {
            this.updateWidgets();
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() != this && (long)aWTEvent.getID() == 128L) {
            this.readFields();
            return;
        }
        super.processEvent(aWTEvent);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    public void firePropertyChange() {
        Vector vector;
        RectangleEditor rectangleEditor = this;
        synchronized (rectangleEditor) {
            if (this.listeners == null) {
                Object var4_2 = null;
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, null, null);
        int n = 0;
        while (n < vector.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public RectangleEditor() {
        this.setLayout(new GridLayout(1, 4));
        this.setSize(this.getInsets().left + this.getInsets().right + 20, this.getInsets().top + this.getInsets().bottom + 20);
        this.xField = new JTextField("0", 4);
        this.yField = new JTextField("0", 4);
        this.hField = new JTextField("0", 4);
        this.wField = new JTextField("0", 4);
        this.add(this.xField);
        this.add(this.yField);
        this.add(this.hField);
        this.add(this.wField);
    }
}

